\name{GrayscaleFillholeImageFilter}
\alias{GrayscaleFillholeImageFilter}
\title{GrayscaleFillholeImageFilter}
\Rdversion{1.1}
\docType{class}
\description{
Remove local minima not connected to the boundary of the image.
GrayscaleFillholeImageFilter}
\details{
GrayscaleFillholeImageFilter fills holes in a grayscale image. Holes are local minima in the
grayscale topography that are not connected to boundaries of the
image. Gray level values adjacent to a hole are extrapolated across
the hole.
This filter is used to smooth over local minima without affecting the
values of local maxima. If you take the difference between the output
of this filter and the original image (and perhaps threshold the
difference above a small value), you'll obtain a map of the local
minima.
This filter uses the ReconstructionByErosionImageFilter . It provides its own input as the "mask" input to the geodesic
erosion. The "marker" image for the geodesic erosion is constructed
such that boundary pixels match the boundary pixels of the input image
and the interior pixels are set to the maximum pixel value in the
input image.
Geodesic morphology and the Fillhole algorithm is described in Chapter
6 of Pierre Soille's book "Morphological Image Analysis: Principles
and Applications", Second Edition, Springer, 2003.
See:
ReconstructionByErosionImageFilter
MorphologyImageFilter , GrayscaleErodeImageFilter , GrayscaleFunctionErodeImageFilter , BinaryErodeImageFilter
GrayscaleFillhole for the procedural interface
itk::GrayscaleFillholeImageFilter for the Doxygen on the original ITK class.
GrayscaleFillholeImageFilter}
%C++ includes: sitkGrayscaleFillholeImageFilter.h
\section{Methods}{
\describe{
\item{Image Execute(const Image &image1):}{
Execute the filter on the input image
}
\item{Self FullyConnectedOff():}{}
\item{Self FullyConnectedOn():}{
Set the value of FullyConnected to true or false respectfully.
}
\item{bool GetFullyConnected() const:}{
Set/Get whether the connected components are defined strictly by face
connectivity or by face+edge+vertex connectivity. Default is
FullyConnectedOff. For objects that are 1 pixel wide, use
FullyConnectedOn.
}
\item{std::string GetName() const:}{
Name of this class
}
\item{ GrayscaleFillholeImageFilter():}{
Default Constructor that takes no arguments and initializes default
parameters
}
\item{Self SetFullyConnected(bool FullyConnected):}{
Set/Get whether the connected components are defined strictly by face
connectivity or by face+edge+vertex connectivity. Default is
FullyConnectedOff. For objects that are 1 pixel wide, use
FullyConnectedOn.
}
\item{std::string ToString() const:}{
Print ourselves out
}
\item{ ~GrayscaleFillholeImageFilter():}{
Destructor
}
}
}
