/*
 * Decompiled with CFR 0.152.
 */
package reactor.netty.http.client;

import io.micrometer.core.instrument.Meter;
import io.micrometer.core.instrument.Tags;
import io.micrometer.core.instrument.Timer;
import java.net.SocketAddress;
import java.util.concurrent.TimeUnit;
import reactor.core.Disposable;
import reactor.netty.Metrics;
import reactor.netty.http.client.Http2ConnectionProviderMeters;
import reactor.netty.internal.shaded.reactor.pool.PoolMetricsRecorder;

final class MicrometerPoolMetricsRecorder
implements Disposable,
PoolMetricsRecorder {
    final Timer pendingSuccessTimer;
    final Timer pendingErrorTimer;

    MicrometerPoolMetricsRecorder(String id, String poolName, SocketAddress remoteAddress) {
        this.pendingSuccessTimer = MicrometerPoolMetricsRecorder.buildTimer(id, poolName, remoteAddress, "SUCCESS");
        this.pendingErrorTimer = MicrometerPoolMetricsRecorder.buildTimer(id, poolName, remoteAddress, "ERROR");
    }

    public void recordAllocationSuccessAndLatency(long latencyMs) {
    }

    public void recordAllocationFailureAndLatency(long latencyMs) {
    }

    public void recordResetLatency(long latencyMs) {
    }

    public void recordDestroyLatency(long latencyMs) {
    }

    public void recordRecycled() {
    }

    public void recordLifetimeDuration(long millisecondsSinceAllocation) {
    }

    public void recordIdleTime(long millisecondsIdle) {
    }

    public void recordSlowPath() {
    }

    public void recordFastPath() {
    }

    public void recordPendingSuccessAndLatency(long latencyMs) {
        this.pendingSuccessTimer.record(latencyMs, TimeUnit.MILLISECONDS);
    }

    public void recordPendingFailureAndLatency(long latencyMs) {
        this.pendingErrorTimer.record(latencyMs, TimeUnit.MILLISECONDS);
    }

    public void dispose() {
        Metrics.REGISTRY.remove((Meter)this.pendingSuccessTimer);
        Metrics.REGISTRY.remove((Meter)this.pendingErrorTimer);
    }

    static Timer buildTimer(String id, String poolName, SocketAddress remoteAddress, String status) {
        return Timer.builder((String)Http2ConnectionProviderMeters.PENDING_STREAMS_TIME.getName()).tags((Iterable)Tags.of((String[])new String[]{Http2ConnectionProviderMeters.PendingStreamsTimeTags.ID.asString(), id, Http2ConnectionProviderMeters.PendingStreamsTimeTags.REMOTE_ADDRESS.asString(), Metrics.formatSocketAddress((SocketAddress)remoteAddress), Http2ConnectionProviderMeters.PendingStreamsTimeTags.NAME.asString(), poolName, Http2ConnectionProviderMeters.PendingStreamsTimeTags.STATUS.asString(), status})).register(Metrics.REGISTRY);
    }
}

