"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.validateDataView = validateDataView;
var _types = require("./types");
/*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */

function dataViewContainsSpaces(dataView) {
  return dataView.includes(' ');
}
function findIllegalCharacters(dataView) {
  const illegalCharacters = _types.ILLEGAL_CHARACTERS_VISIBLE.reduce((chars, char) => {
    if (dataView.includes(char)) {
      chars.push(char);
    }
    return chars;
  }, []);
  return illegalCharacters;
}
function validateDataView(dataView) {
  const errors = {};
  const illegalCharacters = findIllegalCharacters(dataView);
  if (illegalCharacters.length) {
    errors[_types.ILLEGAL_CHARACTERS_KEY] = illegalCharacters;
  }
  if (dataViewContainsSpaces(dataView)) {
    errors[_types.CONTAINS_SPACES_KEY] = true;
  }
  return errors;
}