/*
 * Decompiled with CFR 0.152.
 */
package mediathek.config;

import mediathek.tool.dns.IPvPreferenceMode;
import picocli.CommandLine;

@CommandLine.Command(name="MediathekView")
public class Config {
    @CommandLine.Parameters(index="0", paramLabel="<Pfad zum Verzeichnis>", description={"Pfad zum Einstellungsverzeichnis f\u00fcr Portablen Betrieb"}, arity="0..1")
    public static String baseFilePath;
    @CommandLine.Option(names={"-dpm", "--dns-preference-mode"}, description={"Bevorzugtes IP-Protokoll f\u00fcr DNS festlegen"})
    private static IPvPreferenceMode dnsIpPreferenceMode;
    @CommandLine.Option(names={"-d", "--debug"}, hidden=true, description={"Debug-Modus aktivieren (F\u00dcR ENTWICKLER)"})
    private static boolean debug;
    @CommandLine.Option(names={"-dfd", "--disable-flatlaf-decorations"}, description={"Deaktiviert unter Linux Window Manager Dekorationen"})
    private static boolean disableFlatLafDecorations;
    @CommandLine.Option(names={"-n", "--num-cpus"}, hidden=true, description={"Anzahl der genutzen CPU-Kerne festlegen (F\u00dcR ENTWICKLER)"})
    private static int numCpus;
    @CommandLine.Option(names={"-e", "--enhanced-logging"}, description={"Erweiterten Log-Modus aktivieren"})
    private static boolean enhancedLogging;
    @CommandLine.Option(names={"-s", "--swing-thread-checker"}, description={"Swing EDT Thread Repaint Manager installieren (F\u00dcR ENTWICKLER)"}, hidden=true)
    private static boolean installThreadCheckingRepaintManager;
    @CommandLine.Option(names={"-t", "--debug-http-traffic"}, hidden=true, description={"Logging f\u00fcr HTTP Traffic aktivieren (F\u00dcR ENTWICKLER)"})
    private static boolean debugHttpTraffic;
    private static boolean portableMode;
    @CommandLine.Option(names={"-m", "--maximized"}, description={"Programmfenster beim Start maximieren"})
    private static boolean startMaximized;
    @CommandLine.Option(names={"-h", "--help"}, usageHelp=true, description={"Hilfe anzeigen"})
    private static boolean helpRequested;
    @CommandLine.Option(names={"-f", "--disable-file-logging"}, description={"Speichern des Log output in Datei deaktivieren"})
    private static boolean fileLoggingDisabled;
    @CommandLine.Option(names={"-nj", "--no-jvm-param-checks"}, description={"JVM Parameter-Pr\u00fcfung deaktivieren"})
    private static boolean disableJvmParameterChecks;
    @CommandLine.Option(names={"-ns", "--no-splash"}, description={"Splash-Screen nicht anzeigen"})
    private static boolean disableSplashScreen;
    @CommandLine.Option(names={"-dq", "--download-quit"}, description={"Automatisch downloaden, dann beenden"})
    private static boolean downloadAndQuit;

    public static boolean isDisableFlatLafDecorations() {
        return disableFlatLafDecorations;
    }

    public static IPvPreferenceMode getDnsIpPreferenceMode() {
        return dnsIpPreferenceMode;
    }

    public static void setDnsIpPreferenceMode(IPvPreferenceMode dnsIpPreferenceMode) {
        Config.dnsIpPreferenceMode = dnsIpPreferenceMode;
    }

    public static boolean shouldDownloadAndQuit() {
        return downloadAndQuit;
    }

    public static boolean isSplashScreenDisabled() {
        return disableSplashScreen;
    }

    public static boolean isDisableJvmParameterChecks() {
        return disableJvmParameterChecks;
    }

    public static boolean isInstallThreadCheckingRepaintManager() {
        return installThreadCheckingRepaintManager;
    }

    public static int getNumCpus() {
        return numCpus;
    }

    public static void setNumCpus(int num) {
        numCpus = num;
    }

    public static boolean isPortableMode() {
        return portableMode;
    }

    public static void setPortableMode(boolean portableMode) {
        Config.portableMode = portableMode;
    }

    public static boolean isEnhancedLoggingEnabled() {
        return enhancedLogging;
    }

    public static boolean isDebugModeEnabled() {
        return debug;
    }

    public static boolean isFileLoggingDisabled() {
        return fileLoggingDisabled;
    }

    public static boolean isStartMaximized() {
        return startMaximized;
    }

    public static boolean isHttpTrafficDebuggingEnabled() {
        return debugHttpTraffic;
    }

    static {
        dnsIpPreferenceMode = IPvPreferenceMode.IPV4_ONLY;
    }
}

