/*
 * Decompiled with CFR 0.152.
 */
package java.io;

import java.io.BDFileSystemImpl;
import java.io.FileSystem;

class DefaultFileSystem {
    DefaultFileSystem() {
    }

    static FileSystem getNativeFileSystem() {
        try {
            return (FileSystem)Class.forName(System.getProperty("org.videolan.bdj_filesystem")).newInstance();
        }
        catch (Exception e) {
            Exception e3 = e;
            try {
                return (FileSystem)Class.forName("java.io.UnixFileSystem").newInstance();
            }
            catch (Exception e2) {
                Exception e1 = e2;
                try {
                    return (FileSystem)Class.forName("java.io.WinNTFileSystem").newInstance();
                }
                catch (Exception e4) {
                    Exception e22 = e4;
                    System.err.println("Unsupported native filesystem !\n\t" + e1 + "\n\t" + e22 + "\n\t" + e3);
                    throw new Error("No filesystem implementation found");
                }
            }
        }
    }

    public static FileSystem getFileSystem() {
        FileSystem nativeFs = DefaultFileSystem.getNativeFileSystem();
        return new BDFileSystemImpl(nativeFs);
    }
}

