/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.sdk;

import io.opentelemetry.api.OpenTelemetry;
import io.opentelemetry.api.logs.LoggerBuilder;
import io.opentelemetry.api.logs.LoggerProvider;
import io.opentelemetry.api.metrics.MeterBuilder;
import io.opentelemetry.api.metrics.MeterProvider;
import io.opentelemetry.api.trace.Tracer;
import io.opentelemetry.api.trace.TracerBuilder;
import io.opentelemetry.api.trace.TracerProvider;
import io.opentelemetry.context.propagation.ContextPropagators;
import io.opentelemetry.sdk.OpenTelemetrySdkBuilder;
import io.opentelemetry.sdk.common.CompletableResultCode;
import io.opentelemetry.sdk.logs.SdkLoggerProvider;
import io.opentelemetry.sdk.metrics.SdkMeterProvider;
import io.opentelemetry.sdk.trace.SdkTracerProvider;
import java.io.Closeable;
import java.util.ArrayList;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Logger;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public final class OpenTelemetrySdk
implements OpenTelemetry,
Closeable {
    private static final Logger LOGGER = Logger.getLogger(OpenTelemetrySdk.class.getName());
    private final AtomicBoolean isShutdown = new AtomicBoolean(false);
    private final ObfuscatedTracerProvider tracerProvider;
    private final ObfuscatedMeterProvider meterProvider;
    private final ObfuscatedLoggerProvider loggerProvider;
    private final ContextPropagators propagators;

    OpenTelemetrySdk(SdkTracerProvider tracerProvider, SdkMeterProvider meterProvider, SdkLoggerProvider loggerProvider, ContextPropagators propagators) {
        this.tracerProvider = new ObfuscatedTracerProvider(tracerProvider);
        this.meterProvider = new ObfuscatedMeterProvider(meterProvider);
        this.loggerProvider = new ObfuscatedLoggerProvider(loggerProvider);
        this.propagators = propagators;
    }

    public static OpenTelemetrySdkBuilder builder() {
        return new OpenTelemetrySdkBuilder();
    }

    public TracerProvider getTracerProvider() {
        return this.tracerProvider;
    }

    public SdkTracerProvider getSdkTracerProvider() {
        return this.tracerProvider.unobfuscate();
    }

    public MeterProvider getMeterProvider() {
        return this.meterProvider;
    }

    public SdkMeterProvider getSdkMeterProvider() {
        return this.meterProvider.unobfuscate();
    }

    public LoggerProvider getLogsBridge() {
        return this.loggerProvider;
    }

    public SdkLoggerProvider getSdkLoggerProvider() {
        return this.loggerProvider.unobfuscate();
    }

    public ContextPropagators getPropagators() {
        return this.propagators;
    }

    public CompletableResultCode shutdown() {
        if (!this.isShutdown.compareAndSet(false, true)) {
            LOGGER.info("Multiple shutdown calls");
            return CompletableResultCode.ofSuccess();
        }
        ArrayList<CompletableResultCode> results = new ArrayList<CompletableResultCode>();
        results.add(this.tracerProvider.unobfuscate().shutdown());
        results.add(this.meterProvider.unobfuscate().shutdown());
        results.add(this.loggerProvider.unobfuscate().shutdown());
        return CompletableResultCode.ofAll(results);
    }

    @Override
    public void close() {
        this.shutdown().join(10L, TimeUnit.SECONDS);
    }

    public String toString() {
        return "OpenTelemetrySdk{tracerProvider=" + this.tracerProvider.unobfuscate() + ", meterProvider=" + this.meterProvider.unobfuscate() + ", loggerProvider=" + this.loggerProvider.unobfuscate() + ", propagators=" + this.propagators + "}";
    }

    @ThreadSafe
    static class ObfuscatedTracerProvider
    implements TracerProvider {
        private final SdkTracerProvider delegate;

        ObfuscatedTracerProvider(SdkTracerProvider delegate) {
            this.delegate = delegate;
        }

        public Tracer get(String instrumentationScopeName) {
            return this.delegate.get(instrumentationScopeName);
        }

        public Tracer get(String instrumentationScopeName, String instrumentationScopeVersion) {
            return this.delegate.get(instrumentationScopeName, instrumentationScopeVersion);
        }

        public TracerBuilder tracerBuilder(String instrumentationScopeName) {
            return this.delegate.tracerBuilder(instrumentationScopeName);
        }

        public SdkTracerProvider unobfuscate() {
            return this.delegate;
        }
    }

    @ThreadSafe
    static class ObfuscatedMeterProvider
    implements MeterProvider {
        private final SdkMeterProvider delegate;

        ObfuscatedMeterProvider(SdkMeterProvider delegate) {
            this.delegate = delegate;
        }

        public MeterBuilder meterBuilder(String instrumentationScopeName) {
            return this.delegate.meterBuilder(instrumentationScopeName);
        }

        public SdkMeterProvider unobfuscate() {
            return this.delegate;
        }
    }

    @ThreadSafe
    static class ObfuscatedLoggerProvider
    implements LoggerProvider {
        private final SdkLoggerProvider delegate;

        ObfuscatedLoggerProvider(SdkLoggerProvider delegate) {
            this.delegate = delegate;
        }

        public LoggerBuilder loggerBuilder(String instrumentationScopeName) {
            return this.delegate.loggerBuilder(instrumentationScopeName);
        }

        public SdkLoggerProvider unobfuscate() {
            return this.delegate;
        }
    }
}

