/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.mutiny;

import io.smallrye.mutiny.helpers.ParameterValidation;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Supplier;

public final class Context {
    private volatile ConcurrentHashMap<String, Object> entries;

    public static Context empty() {
        return new Context();
    }

    public static Context of(Object ... entries) {
        Objects.requireNonNull(entries, "The entries array cannot be null");
        if (entries.length % 2 != 0) {
            throw new IllegalArgumentException("Arguments must be balanced to form (key, value) pairs");
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        for (int i = 0; i < entries.length; i += 2) {
            String key = ParameterValidation.nonNull(entries[i], "key").toString();
            Object value = ParameterValidation.nonNull(entries[i + 1], "value");
            map.put(key, value);
        }
        return new Context(map);
    }

    public static Context from(Map<String, ?> entries) {
        return new Context(Objects.requireNonNull(entries, "The entries map cannot be null"));
    }

    private Context() {
        this.entries = null;
    }

    private Context(Map<String, ?> initialEntries) {
        this.entries = new ConcurrentHashMap(initialEntries);
    }

    public boolean contains(String key) {
        if (this.entries == null) {
            return false;
        }
        return this.entries.containsKey(key);
    }

    public <T> T get(String key) throws NoSuchElementException {
        if (this.entries == null) {
            throw new NoSuchElementException("The context is empty");
        }
        Object value = this.entries.get(key);
        if (value == null) {
            throw new NoSuchElementException("The context does not have a value for key " + key);
        }
        return (T)value;
    }

    public <T> T getOrElse(String key, Supplier<? extends T> alternativeSupplier) {
        Object value;
        if (this.entries != null && (value = this.entries.get(key)) != null) {
            return (T)value;
        }
        return alternativeSupplier.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Context put(String key, Object value) {
        if (this.entries == null) {
            Context context = this;
            synchronized (context) {
                if (this.entries == null) {
                    this.entries = new ConcurrentHashMap(8);
                }
            }
        }
        this.entries.put(key, value);
        return this;
    }

    public Context delete(String key) {
        if (this.entries != null) {
            this.entries.remove(key);
        }
        return this;
    }

    public boolean isEmpty() {
        return this.entries == null || this.entries.isEmpty();
    }

    public Set<String> keys() {
        if (this.entries == null) {
            return Collections.emptySet();
        }
        HashSet<String> set = new HashSet<String>();
        Enumeration<String> enumeration = this.entries.keys();
        while (enumeration.hasMoreElements()) {
            set.add(enumeration.nextElement());
        }
        return set;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        Context context = (Context)other;
        return Objects.equals(this.entries, context.entries);
    }

    public int hashCode() {
        return Objects.hash(this.entries);
    }

    public String toString() {
        return "Context{entries=" + String.valueOf(this.entries) + "}";
    }
}

