/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.websocket.pojo;

import jakarta.websocket.DecodeException;
import jakarta.websocket.Decoder;
import jakarta.websocket.MessageHandler;
import jakarta.websocket.Session;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import javax.naming.NamingException;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.apache.tomcat.InstanceManager;
import org.apache.tomcat.util.res.StringManager;
import org.apache.tomcat.websocket.WsSession;
import org.apache.tomcat.websocket.pojo.PojoMessageHandlerBase;

public abstract class PojoMessageHandlerWholeBase<T>
extends PojoMessageHandlerBase<T>
implements MessageHandler.Whole<T> {
    private final Log log = LogFactory.getLog(PojoMessageHandlerWholeBase.class);
    private static final StringManager sm = StringManager.getManager(PojoMessageHandlerWholeBase.class);
    protected final List<Decoder> decoders = new ArrayList<Decoder>();

    public PojoMessageHandlerWholeBase(Object object, Method method, Session session, Object[] objectArray, int n, boolean bl, int n2, long l) {
        super(object, method, session, objectArray, n, bl, n2, l);
    }

    protected Decoder createDecoderInstance(Class<? extends Decoder> clazz) throws ReflectiveOperationException, NamingException {
        InstanceManager instanceManager = ((WsSession)this.session).getInstanceManager();
        if (instanceManager == null) {
            return clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        return (Decoder)instanceManager.newInstance(clazz);
    }

    public final void onMessage(T t) {
        Object object;
        if (this.params.length == 1 && this.params[0] instanceof DecodeException) {
            ((WsSession)this.session).getLocal().onError(this.session, (Throwable)((DecodeException)((Object)this.params[0])));
            return;
        }
        try {
            object = this.decode(t);
        }
        catch (DecodeException decodeException) {
            ((WsSession)this.session).getLocal().onError(this.session, (Throwable)decodeException);
            return;
        }
        if (object == null) {
            object = this.convert ? this.convert(t) : t;
        }
        Object[] objectArray = (Object[])this.params.clone();
        if (this.indexSession != -1) {
            objectArray[this.indexSession] = this.session;
        }
        objectArray[this.indexPayload] = object;
        Object object2 = null;
        try {
            object2 = this.method.invoke(this.pojo, objectArray);
        }
        catch (IllegalAccessException | InvocationTargetException reflectiveOperationException) {
            this.handlePojoMethodException(reflectiveOperationException);
        }
        this.processResult(object2);
    }

    protected void onClose() {
        InstanceManager instanceManager = ((WsSession)this.session).getInstanceManager();
        for (Decoder decoder : this.decoders) {
            decoder.destroy();
            if (instanceManager == null) continue;
            try {
                instanceManager.destroyInstance((Object)decoder);
            }
            catch (IllegalAccessException | InvocationTargetException reflectiveOperationException) {
                this.log.warn((Object)sm.getString("pojoMessageHandlerWholeBase.decodeDestroyFailed", new Object[]{decoder.getClass()}), (Throwable)reflectiveOperationException);
            }
        }
    }

    protected Object convert(T t) {
        return t;
    }

    protected abstract Object decode(T var1) throws DecodeException;
}

