/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ml.memory.action.conversation;

import java.io.IOException;
import lombok.Generated;
import org.opensearch.action.ActionRequest;
import org.opensearch.action.ActionRequestValidationException;
import org.opensearch.action.ValidateActions;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.rest.RestRequest;

public class GetInteractionRequest
extends ActionRequest {
    private String interactionId;

    public GetInteractionRequest(StreamInput in) throws IOException {
        super(in);
        this.interactionId = in.readString();
    }

    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeString(this.interactionId);
    }

    public ActionRequestValidationException validate() {
        ActionRequestValidationException exception = null;
        if (this.interactionId == null) {
            exception = ValidateActions.addValidationError((String)"Get Interaction Request must have an interaction id", exception);
        }
        return exception;
    }

    public static GetInteractionRequest fromRestRequest(RestRequest request) throws IOException {
        String interactionId = request.param("message_id");
        return new GetInteractionRequest(interactionId);
    }

    @Generated
    public GetInteractionRequest(String interactionId) {
        this.interactionId = interactionId;
    }

    @Generated
    public String getInteractionId() {
        return this.interactionId;
    }
}

