/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.discovery.ec2;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UncheckedIOException;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.SpecialPermission;
import org.opensearch.common.SuppressForbidden;
import org.opensearch.common.network.NetworkService;
import org.opensearch.common.settings.Setting;
import org.opensearch.common.settings.Settings;
import org.opensearch.discovery.SeedHostsProvider;
import org.opensearch.discovery.ec2.AwsEc2SeedHostsProvider;
import org.opensearch.discovery.ec2.AwsEc2Service;
import org.opensearch.discovery.ec2.AwsEc2ServiceImpl;
import org.opensearch.discovery.ec2.Ec2ClientSettings;
import org.opensearch.discovery.ec2.Ec2NameResolver;
import org.opensearch.node.Node;
import org.opensearch.plugins.DiscoveryPlugin;
import org.opensearch.plugins.Plugin;
import org.opensearch.plugins.ReloadablePlugin;
import org.opensearch.secure_sm.AccessController;
import org.opensearch.transport.TransportService;
import software.amazon.awssdk.core.SdkSystemSetting;

public class Ec2DiscoveryPlugin
extends Plugin
implements DiscoveryPlugin,
ReloadablePlugin {
    private static Logger logger = LogManager.getLogger(Ec2DiscoveryPlugin.class);
    public static final String EC2 = "ec2";
    private final Settings settings;
    protected final AwsEc2Service ec2Service;

    public Ec2DiscoveryPlugin(Settings settings) {
        this(settings, new AwsEc2ServiceImpl());
    }

    protected Ec2DiscoveryPlugin(Settings settings, AwsEc2ServiceImpl ec2Service) {
        this.settings = settings;
        this.ec2Service = ec2Service;
        this.reload(settings);
    }

    public NetworkService.CustomNameResolver getCustomNameResolver(Settings settings) {
        logger.debug("Register _ec2_, _ec2:xxx_ network names");
        return new Ec2NameResolver();
    }

    public Map<String, Supplier<SeedHostsProvider>> getSeedHostProviders(TransportService transportService, NetworkService networkService) {
        return Collections.singletonMap(EC2, () -> new AwsEc2SeedHostsProvider(this.settings, transportService, this.ec2Service));
    }

    public List<Setting<?>> getSettings() {
        return Arrays.asList(Ec2ClientSettings.ACCESS_KEY_SETTING, Ec2ClientSettings.SECRET_KEY_SETTING, Ec2ClientSettings.SESSION_TOKEN_SETTING, Ec2ClientSettings.ENDPOINT_SETTING, Ec2ClientSettings.REGION_SETTING, Ec2ClientSettings.PROTOCOL_SETTING, Ec2ClientSettings.PROXY_HOST_SETTING, Ec2ClientSettings.PROXY_PORT_SETTING, Ec2ClientSettings.PROXY_USERNAME_SETTING, Ec2ClientSettings.PROXY_PASSWORD_SETTING, Ec2ClientSettings.READ_TIMEOUT_SETTING, AwsEc2Service.HOST_TYPE_SETTING, AwsEc2Service.ANY_GROUP_SETTING, AwsEc2Service.GROUPS_SETTING, AwsEc2Service.AVAILABILITY_ZONES_SETTING, AwsEc2Service.NODE_CACHE_TIME_SETTING, AwsEc2Service.TAG_SETTING, AwsEc2Service.AUTO_ATTRIBUTE_SETTING);
    }

    public Settings additionalSettings() {
        Settings.Builder builder = Settings.builder();
        Optional ec2MetadataServiceEndpoint = SdkSystemSetting.AWS_EC2_METADATA_SERVICE_ENDPOINT.getStringValue();
        if (ec2MetadataServiceEndpoint.isPresent()) {
            builder.put(Ec2DiscoveryPlugin.getAvailabilityZoneNodeAttributes(this.settings, (String)ec2MetadataServiceEndpoint.get() + "/latest/meta-data/placement/availability-zone"));
        }
        return builder.build();
    }

    @SuppressForbidden(reason="We call getInputStream in doPrivileged and provide SocketPermission")
    static Settings getAvailabilityZoneNodeAttributes(Settings settings, String azMetadataUrl) {
        URLConnection urlConnection;
        URL url;
        if (!((Boolean)AwsEc2Service.AUTO_ATTRIBUTE_SETTING.get(settings)).booleanValue()) {
            return Settings.EMPTY;
        }
        Settings.Builder attrs = Settings.builder();
        try {
            url = new URL(azMetadataUrl);
            logger.debug("obtaining ec2 [placement/availability-zone] from ec2 meta-data url {}", (Object)url);
            urlConnection = (URLConnection)AccessController.doPrivilegedChecked(() -> url.openConnection());
            urlConnection.setConnectTimeout(2000);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        try (InputStream in = (InputStream)AccessController.doPrivilegedChecked(urlConnection::getInputStream);
             BufferedReader urlReader = new BufferedReader(new InputStreamReader(in, StandardCharsets.UTF_8));){
            String metadataResult = urlReader.readLine();
            if (metadataResult == null || metadataResult.length() == 0) {
                throw new IllegalStateException("no ec2 metadata returned from " + String.valueOf(url));
            }
            attrs.put(Node.NODE_ATTRIBUTES.getKey() + "aws_availability_zone", metadataResult);
        }
        catch (IOException e) {
            logger.error("failed to get metadata for [placement/availability-zone]", (Throwable)e);
        }
        return attrs.build();
    }

    public void close() throws IOException {
        this.ec2Service.close();
    }

    public void reload(Settings settings) {
        Ec2ClientSettings clientSettings = Ec2ClientSettings.getClientSettings(settings);
        this.ec2Service.refreshAndClearCache(clientSettings);
    }

    static {
        SpecialPermission.check();
    }
}

