/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.pki.internal.cert;

import java.io.ByteArrayInputStream;
import java.io.EOFException;
import java.io.Externalizable;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.OutputStream;
import java.io.PushbackInputStream;
import java.util.ArrayList;
import java.util.List;
import oracle.security.pki.internal.asn1.ASN1ConstructedInputStream;
import oracle.security.pki.internal.asn1.ASN1FormatException;
import oracle.security.pki.internal.asn1.ASN1GenericConstructed;
import oracle.security.pki.internal.asn1.ASN1Object;
import oracle.security.pki.internal.asn1.ASN1ObjectID;
import oracle.security.pki.internal.asn1.ASN1OctetString;
import oracle.security.pki.internal.asn1.ASN1Sequence;
import oracle.security.pki.internal.asn1.ASN1SequenceInputStream;
import oracle.security.pki.internal.asn1.ASN1String;
import oracle.security.pki.internal.asn1.ASN1Utils;
import oracle.security.pki.internal.cert.X500Name;
import oracle.security.pki.util.Utils;

public class GeneralName
implements Externalizable,
ASN1Object {
    private Type a;
    private ASN1Object b;
    private ASN1Object c = null;

    public GeneralName() {
    }

    public GeneralName(Type type, ASN1Object aSN1Object) {
        try {
            this.a(type, aSN1Object);
        }
        catch (IOException iOException) {
            throw new IllegalArgumentException(iOException.toString());
        }
    }

    public GeneralName(Type type, String string) {
        this(type, new ASN1String(string, 22));
    }

    public GeneralName(X500Name x500Name) {
        this(Type.e, x500Name);
    }

    public GeneralName(InputStream inputStream) throws IOException {
        this.input(inputStream);
    }

    private void a(Type type, ASN1Object aSN1Object) throws IOException {
        if (type == Type.a) {
            ASN1SequenceInputStream aSN1SequenceInputStream = new ASN1SequenceInputStream(Utils.toStream(aSN1Object));
            new ASN1ObjectID(aSN1SequenceInputStream);
            new ASN1ConstructedInputStream((InputStream)aSN1SequenceInputStream, 0);
        } else if (type == Type.b || type == Type.c || type == Type.g) {
            if (!(aSN1Object instanceof ASN1String)) {
                throw new ASN1FormatException("Invalid value for " + type);
            }
            if (((ASN1String)aSN1Object).c() != 22) {
                throw new ASN1FormatException("Invalid value for " + type);
            }
        } else if (type == Type.h) {
            if (!(aSN1Object instanceof ASN1OctetString)) {
                throw new ASN1FormatException("Invalid value for " + type);
            }
        } else if (type == Type.d || type == Type.e || type == Type.f) {
            new ASN1Sequence(Utils.toStream(aSN1Object));
        } else if (type == Type.i) {
            new ASN1ObjectID(Utils.toStream(aSN1Object));
        }
        this.c = null;
        this.a = type;
        this.b = aSN1Object;
    }

    public Type a() {
        return this.a;
    }

    public ASN1Object b() {
        return this.b;
    }

    public List<?> c() {
        ArrayList<Object> arrayList = new ArrayList<Object>(2);
        arrayList.add(new Integer(this.a.j));
        if (this.b instanceof ASN1String) {
            arrayList.add(((ASN1String)this.b).b());
        } else if (this.b instanceof ASN1ObjectID) {
            arrayList.add(((ASN1ObjectID)this.b).d());
        } else if (this.b instanceof X500Name) {
            arrayList.add(((X500Name)this.b).toString());
        } else {
            arrayList.add(Utils.toBytes(this.b));
        }
        return arrayList;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() == object.getClass()) {
            GeneralName generalName = (GeneralName)object;
            if (this.a == generalName.a) {
                return Utils.areEqual(Utils.toBytes(this.b), Utils.toBytes(generalName.b));
            }
            return false;
        }
        if (object instanceof ASN1Object) {
            return Utils.areEqual(Utils.toBytes(this.b), Utils.toBytes((ASN1Object)object));
        }
        return false;
    }

    public String toString() {
        if (this.b == null) {
            return "";
        }
        if (this.a.equals(Type.h)) {
            String string = "{ " + this.a + ": ";
            byte[] byArray = ((ASN1OctetString)this.b).b();
            if (byArray.length == 4) {
                try {
                    string = string + GeneralName.a(byArray) + " }";
                }
                catch (IOException iOException) {
                    System.out.println("IP address not encoded correctly.");
                }
            } else {
                try {
                    string = string + GeneralName.b(byArray) + " }";
                }
                catch (IOException iOException) {
                    System.out.println("IP address not encoded correctly.");
                }
            }
            return string;
        }
        return "{ " + this.a + ": " + this.b + " }";
    }

    public static String a(byte[] byArray) throws IOException {
        if (byArray.length != 4) {
            throw new IOException("Invalid IPv4 Address");
        }
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < byArray.length; ++i) {
            try {
                int n = byArray[i] & 0xFF;
                stringBuffer.append(Integer.toString(n));
                if (i >= byArray.length - 1) continue;
                stringBuffer.append(".");
                continue;
            }
            catch (NumberFormatException numberFormatException) {
                throw new IOException("Invalid IPv4 Address");
            }
        }
        return stringBuffer.toString();
    }

    public static String b(byte[] byArray) throws IOException {
        StringBuffer stringBuffer = new StringBuffer();
        if (byArray.length != 16) {
            throw new IOException("Invalid IPv6 address");
        }
        for (int i = 0; i < byArray.length; i += 2) {
            try {
                String string = Integer.toHexString(byArray[i] & 0xFF);
                String string2 = Integer.toHexString(byArray[i + 1] & 0xFF);
                if (string.length() == 1) {
                    string = "0" + string;
                }
                if (string2.length() == 1) {
                    string2 = "0" + string2;
                }
                stringBuffer.append(string).append(string2);
                if (i >= byArray.length - 2) continue;
                stringBuffer.append(":");
                continue;
            }
            catch (NumberFormatException numberFormatException) {
                throw new IOException("Invalid IPv6 address");
            }
        }
        return stringBuffer.toString();
    }

    public static byte[] a(String string) throws IOException {
        String[] stringArray = string.split("\\.");
        if (stringArray.length != 4) {
            throw new IOException("Invalid IPv4 Address, example of an IPv4 address: 192.0.3.1");
        }
        byte[] byArray = new byte[4];
        for (int i = 0; i < byArray.length; ++i) {
            try {
                int n = Integer.parseInt(stringArray[i]);
                if (n < 0 || n > 255) {
                    throw new IOException("Invalid IPv4 Address, example of an IPv4 address: 192.0.3.1");
                }
                byArray[i] = (byte)n;
                continue;
            }
            catch (NumberFormatException numberFormatException) {
                throw new IOException("Invalid IPv4 Address, example of an IPv4 address: 192.0.3.1");
            }
        }
        return byArray;
    }

    public static byte[] b(String string) throws IOException {
        String[] stringArray = string.split(":");
        if (stringArray.length != 8) {
            throw new IOException("Invalid IPv6 address, example of an IPv6 address: 2002:0db8:85a3:0000:0000:8a2e:0370:7334");
        }
        byte[] byArray = new byte[16];
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].length() != 4) {
                throw new IOException("Invalid IPv6 address, example of an IPv6 address: 2002:0db8:85a3:0000:0000:8a2e:0370:7334");
            }
            try {
                byArray[i * 2] = (byte)Integer.parseInt(stringArray[i].substring(0, 2), 16);
                byArray[i * 2 + 1] = (byte)Integer.parseInt(stringArray[i].substring(2, 4), 16);
                continue;
            }
            catch (NumberFormatException numberFormatException) {
                throw new IOException("Invalid IPv6 address, example of an IPv6 address: 2002:0db8:85a3:0000:0000:8a2e:0370:7334");
            }
        }
        return byArray;
    }

    @Override
    public void input(InputStream inputStream) throws IOException {
        ASN1Object aSN1Object;
        Type type;
        PushbackInputStream pushbackInputStream = inputStream instanceof PushbackInputStream ? (PushbackInputStream)inputStream : new PushbackInputStream(inputStream);
        int n = pushbackInputStream.read();
        if (n == -1) {
            throw new EOFException();
        }
        int n2 = n & 0x20;
        switch (n & 0x1F) {
            case 0: {
                type = Type.a;
                pushbackInputStream.unread(n2 | 0x10);
                aSN1Object = new ASN1Sequence(pushbackInputStream);
                break;
            }
            case 1: {
                type = Type.b;
                pushbackInputStream.unread(n2 | 0x16);
                aSN1Object = new ASN1String(pushbackInputStream);
                break;
            }
            case 2: {
                type = Type.c;
                pushbackInputStream.unread(n2 | 0x16);
                aSN1Object = new ASN1String(pushbackInputStream);
                break;
            }
            case 3: {
                type = Type.d;
                pushbackInputStream.unread(n2 | 0x10);
                aSN1Object = new ASN1Sequence(pushbackInputStream);
                break;
            }
            case 4: {
                type = Type.e;
                pushbackInputStream.unread(n);
                ASN1ConstructedInputStream aSN1ConstructedInputStream = new ASN1ConstructedInputStream((InputStream)pushbackInputStream, 4);
                aSN1Object = new X500Name(aSN1ConstructedInputStream);
                aSN1ConstructedInputStream.b();
                break;
            }
            case 5: {
                type = Type.f;
                pushbackInputStream.unread(n2 | 0x10);
                aSN1Object = new ASN1Sequence(pushbackInputStream);
                break;
            }
            case 6: {
                type = Type.g;
                pushbackInputStream.unread(n2 | 0x16);
                aSN1Object = new ASN1String(pushbackInputStream);
                break;
            }
            case 7: {
                type = Type.h;
                pushbackInputStream.unread(n2 | 4);
                aSN1Object = new ASN1OctetString(pushbackInputStream);
                break;
            }
            case 8: {
                type = Type.i;
                pushbackInputStream.unread(n2 | 6);
                aSN1Object = new ASN1ObjectID(pushbackInputStream);
                break;
            }
            default: {
                throw new ASN1FormatException("Unrecognized tag for GeneralName");
            }
        }
        this.a(type, aSN1Object);
    }

    private ASN1Object d() {
        if (this.c == null) {
            switch (this.a.a()) {
                case 4: {
                    this.c = new ASN1GenericConstructed(this.b, this.a.a());
                    break;
                }
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 5: 
                case 6: 
                case 7: 
                case 8: {
                    this.c = ASN1Utils.a(this.b, this.a.a());
                    break;
                }
            }
        }
        return this.c;
    }

    @Override
    public void output(OutputStream outputStream) throws IOException {
        this.d().output(outputStream);
    }

    @Override
    public int length() {
        return this.d().length();
    }

    @Override
    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        objectOutput.writeObject(Utils.toBytes(this));
    }

    @Override
    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        byte[] byArray;
        try {
            byArray = (byte[])objectInput.readObject();
        }
        catch (ClassCastException classCastException) {
            throw new IOException(classCastException);
        }
        this.input(new ByteArrayInputStream(byArray));
    }

    public static class Type {
        public static final Type a = new Type(0, "otherName");
        public static final Type b = new Type(1, "rfc822Name");
        public static final Type c = new Type(2, "dNSName");
        public static final Type d = new Type(3, "x400Address");
        public static final Type e = new Type(4, "directoryName");
        public static final Type f = new Type(5, "ediPartyName");
        public static final Type g = new Type(6, "uniformResourceIdentifier");
        public static final Type h = new Type(7, "iPAddress");
        public static final Type i = new Type(8, "registeredID");
        private int j;
        private String k;

        private Type(int n, String string) {
            this.j = n;
            this.k = string;
        }

        private int a() {
            return this.j;
        }

        public String toString() {
            return this.k;
        }
    }
}

