/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.ui;

import com.intellij.ide.bookmark.Bookmark;
import com.intellij.ide.bookmark.ui.tree.BookmarkNode;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.VcsNotifier;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.vcs.log.Hash;
import com.intellij.vcs.log.VcsLogBundle;
import com.intellij.vcs.log.impl.VcsLogNavigationUtil;
import com.intellij.vcs.log.ui.VcsLogBookmarkNode;
import com.intellij.vcs.log.ui.VcsLogBookmarkProvider;
import com.intellij.vcs.log.ui.VcsLogBookmarkProviderKt;
import java.util.Map;
import java.util.Objects;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\f\u0010\u0015\u001a\u0006\u0012\u0002\b\u00030\u0016H\u0016J\b\u0010\u0017\u001a\u00020\u0018H\u0016J\b\u0010\u0019\u001a\u00020\u0018H\u0016J\u0010\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u0018H\u0016J\n\u0010\u001d\u001a\u0004\u0018\u00010\u0012H\u0016J\b\u0010\u001e\u001a\u00020\u001fH\u0016J\u0013\u0010 \u001a\u00020\u00182\b\u0010!\u001a\u0004\u0018\u00010\"H\u0096\u0002J\b\u0010#\u001a\u00020\u0012H\u0016R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR \u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u00120\u00118VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014\u00a8\u0006$"}, d2={"Lcom/intellij/vcs/log/ui/VcsLogBookmark;", "Lcom/intellij/ide/bookmark/Bookmark;", "provider", "Lcom/intellij/vcs/log/ui/VcsLogBookmarkProvider;", "root", "Lcom/intellij/openapi/vfs/VirtualFile;", "hash", "Lcom/intellij/vcs/log/Hash;", "<init>", "(Lcom/intellij/vcs/log/ui/VcsLogBookmarkProvider;Lcom/intellij/openapi/vfs/VirtualFile;Lcom/intellij/vcs/log/Hash;)V", "getProvider", "()Lcom/intellij/vcs/log/ui/VcsLogBookmarkProvider;", "getRoot", "()Lcom/intellij/openapi/vfs/VirtualFile;", "getHash", "()Lcom/intellij/vcs/log/Hash;", "attributes", "", "", "getAttributes", "()Ljava/util/Map;", "createNode", "Lcom/intellij/ide/bookmark/ui/tree/BookmarkNode;", "canNavigate", "", "canNavigateToSource", "navigate", "", "requestFocus", "prepareDefaultDescription", "hashCode", "", "equals", "other", "", "toString", "intellij.platform.vcs.log.impl"})
public final class VcsLogBookmark
implements Bookmark {
    @NotNull
    private final VcsLogBookmarkProvider provider;
    @NotNull
    private final VirtualFile root;
    @NotNull
    private final Hash hash;

    public VcsLogBookmark(@NotNull VcsLogBookmarkProvider provider, @NotNull VirtualFile root, @NotNull Hash hash) {
        Intrinsics.checkNotNullParameter((Object)provider, (String)"provider");
        Intrinsics.checkNotNullParameter((Object)root, (String)"root");
        Intrinsics.checkNotNullParameter((Object)hash, (String)"hash");
        this.provider = provider;
        this.root = root;
        this.hash = hash;
    }

    @NotNull
    public VcsLogBookmarkProvider getProvider() {
        return this.provider;
    }

    @NotNull
    public final VirtualFile getRoot() {
        return this.root;
    }

    @NotNull
    public final Hash getHash() {
        return this.hash;
    }

    @NotNull
    public Map<String, String> getAttributes() {
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"root", (Object)this.root.getPath()), TuplesKt.to((Object)"hash", (Object)this.hash.asString())};
        return MapsKt.mapOf((Pair[])pairArray);
    }

    @NotNull
    public BookmarkNode<?> createNode() {
        return new VcsLogBookmarkNode(this.getProvider().getProject(), this);
    }

    public boolean canNavigate() {
        return true;
    }

    public boolean canNavigateToSource() {
        return false;
    }

    public void navigate(boolean requestFocus) {
        VcsLogNavigationUtil.jumpToRevisionAsync$default(this.getProvider().getProject(), this.root, this.hash, null, 8, null).whenComplete((arg_0, arg_1) -> VcsLogBookmark.navigate$lambda$1((arg_0, arg_1) -> VcsLogBookmark.navigate$lambda$0(this, arg_0, arg_1), arg_0, arg_1));
    }

    @Nullable
    public String prepareDefaultDescription() {
        return VcsLogBookmarkProviderKt.access$getDefaultBookmarkDescription(this.getProvider().getProject(), this.root, this.hash);
    }

    public int hashCode() {
        Object[] objectArray = new Object[]{this.getProvider(), this.root, this.hash};
        return Objects.hash(objectArray);
    }

    public boolean equals(@Nullable Object other) {
        return other == this || other instanceof VcsLogBookmark && Intrinsics.areEqual((Object)((VcsLogBookmark)other).getProvider(), (Object)this.getProvider()) && Intrinsics.areEqual((Object)((VcsLogBookmark)other).root, (Object)this.root) && Intrinsics.areEqual((Object)((VcsLogBookmark)other).hash, (Object)this.hash);
    }

    @NotNull
    public String toString() {
        return "VcsLogBookmark(root=" + this.root + ",hash=" + this.hash + ")";
    }

    private static final Unit navigate$lambda$0(VcsLogBookmark this$0, Boolean result, Throwable error) {
        if (!Intrinsics.areEqual((Object)result, (Object)true)) {
            Object[] objectArray = new Object[]{this$0.hash};
            String string = VcsLogBundle.message("vcs.log.commit.prefix", objectArray);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            String commitPresentation = string;
            Object[] objectArray2 = new Object[]{commitPresentation};
            String string2 = VcsLogBundle.message("vcs.log.commit.not.found", objectArray2);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(...)");
            String message = string2;
            VcsNotifier.getInstance((Project)this$0.getProvider().getProject()).notifyWarning("vcs.log.commit.not.found", "", message);
        }
        return Unit.INSTANCE;
    }

    private static final void navigate$lambda$1(Function2 $tmp0, Object p0, Object p1) {
        $tmp0.invoke(p0, p1);
    }
}

