/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.notations;

import org.gradle.api.InvalidUserDataException;
import org.gradle.api.artifacts.component.ComponentIdentifier;
import org.gradle.api.artifacts.component.ModuleComponentIdentifier;
import org.gradle.api.internal.artifacts.DefaultModuleIdentifier;
import org.gradle.api.internal.notations.ModuleNotationValidation;
import org.gradle.internal.Factory;
import org.gradle.internal.component.external.model.DefaultModuleComponentIdentifier;
import org.gradle.internal.typeconversion.MapKey;
import org.gradle.internal.typeconversion.MapNotationConverter;
import org.gradle.internal.typeconversion.NotationConverter;
import org.gradle.internal.typeconversion.NotationParser;
import org.gradle.internal.typeconversion.NotationParserBuilder;
import org.gradle.internal.typeconversion.TypedNotationConverter;

public class ComponentIdentifierParserFactory
implements Factory<NotationParser<Object, ComponentIdentifier>> {
    public NotationParser<Object, ComponentIdentifier> create() {
        return NotationParserBuilder.toType(ComponentIdentifier.class).fromCharSequence((NotationConverter)new StringNotationConverter()).converter((NotationConverter)new ComponentIdentifierMapNotationConverter()).toComposite();
    }

    static class StringNotationConverter
    extends TypedNotationConverter<String, ModuleComponentIdentifier> {
        StringNotationConverter() {
            super(String.class);
        }

        protected ModuleComponentIdentifier parseType(String notation) {
            String[] parts = notation.split(":");
            if (parts.length != 3) {
                throw new InvalidUserDataException("Invalid module component notation: " + notation + " : must be a valid 3 part identifier, eg.: org.gradle:gradle:1.0");
            }
            return DefaultModuleComponentIdentifier.newId(DefaultModuleIdentifier.newId(ModuleNotationValidation.validate(parts[0].trim(), notation), ModuleNotationValidation.validate(parts[1].trim(), notation)), ModuleNotationValidation.validate(parts[2].trim(), notation));
        }
    }

    static class ComponentIdentifierMapNotationConverter
    extends MapNotationConverter<ModuleComponentIdentifier> {
        ComponentIdentifierMapNotationConverter() {
        }

        protected ModuleComponentIdentifier parseMap(@MapKey(value="group") String group, @MapKey(value="name") String name, @MapKey(value="version") String version) {
            return DefaultModuleComponentIdentifier.newId(DefaultModuleIdentifier.newId(ModuleNotationValidation.validate(group.trim()), ModuleNotationValidation.validate(name.trim())), ModuleNotationValidation.validate(version.trim()));
        }
    }
}

