/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.viewer.format.actions;

import docking.ActionContext;
import docking.action.DockingAction;
import docking.action.MenuData;
import ghidra.app.util.viewer.field.FieldFactory;
import ghidra.app.util.viewer.format.FieldFormatModel;
import ghidra.app.util.viewer.format.FieldHeader;
import ghidra.app.util.viewer.format.FieldHeaderLocation;
import ghidra.util.HelpLocation;

public class AddAllFieldAction
extends DockingAction {
    FieldHeader panel;

    public AddAllFieldAction(String owner, FieldHeader panel) {
        super("Add All Field", owner, false);
        this.panel = panel;
        this.setPopupMenuData(new MenuData(new String[]{"Add Field", "All"}, "header a"));
        this.setEnabled(true);
        this.setHelpLocation(new HelpLocation("CodeBrowserPlugin", "Add Field"));
    }

    public boolean isEnabledForContext(ActionContext context) {
        Object contextObject = context.getContextObject();
        if (!(contextObject instanceof FieldHeaderLocation)) {
            return false;
        }
        FieldHeaderLocation loc = (FieldHeaderLocation)contextObject;
        FieldFormatModel modelAtLocation = loc.getModel();
        FieldFactory[] allFactories = modelAtLocation.getAllFactories();
        return allFactories.length > 1;
    }

    public boolean isValidContext(ActionContext context) {
        return context.getContextObject() instanceof FieldHeaderLocation;
    }

    public void actionPerformed(ActionContext context) {
        this.panel.setTabLock(true);
        FieldHeaderLocation loc = (FieldHeaderLocation)context.getContextObject();
        FieldFormatModel modelAtLocation = loc.getModel();
        modelAtLocation.addAllFactories();
    }
}

