/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.pdb2.pdbreader.symbol;

import ghidra.app.util.bin.format.pdb2.pdbreader.AbstractPdb;
import ghidra.app.util.bin.format.pdb2.pdbreader.PdbByteReader;
import ghidra.app.util.bin.format.pdb2.pdbreader.PdbException;
import ghidra.app.util.bin.format.pdb2.pdbreader.StringParseType;
import ghidra.app.util.bin.format.pdb2.pdbreader.symbol.AbstractUnknownMsSymbol;

public class UnknownX1167MsSymbol
extends AbstractUnknownMsSymbol {
    public static final int PDB_ID = 4455;
    private int unknownUnsignedShort1;
    private int unknownUnsignedShort2;
    private int unknownUnsignedShort3;
    private String string;

    public UnknownX1167MsSymbol(AbstractPdb pdb, PdbByteReader reader) throws PdbException {
        super(pdb, reader);
        this.unknownUnsignedShort1 = reader.parseUnsignedShortVal();
        this.unknownUnsignedShort2 = reader.parseUnsignedShortVal();
        this.unknownUnsignedShort3 = reader.parseUnsignedShortVal();
        this.string = reader.parseString(pdb, StringParseType.StringUtf8Nt);
        reader.align4();
    }

    @Override
    public int getPdbId() {
        return 4455;
    }

    public int getUnknownUnsignedShort1() {
        return this.unknownUnsignedShort1;
    }

    public int getUnknownUnsignedShort2() {
        return this.unknownUnsignedShort2;
    }

    public int getUnknownUnsignedShort3() {
        return this.unknownUnsignedShort3;
    }

    public String getStringData() {
        return this.string;
    }

    @Override
    public void emit(StringBuilder builder) {
        builder.append(this.getSymbolTypeName());
        builder.append(String.format("\nunknownUnsignedShort1: %04X", this.unknownUnsignedShort1));
        builder.append(String.format("\nunknownUnsignedShort2: %04X", this.unknownUnsignedShort2));
        builder.append(String.format("\nunknownUnsignedShort3: %04X", this.unknownUnsignedShort3));
        builder.append(String.format("\nString: %s", this.getStringData()));
    }

    @Override
    protected String getSymbolTypeName() {
        return "UNKNOWN_SYMBOL_X1167";
    }
}

