/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.pdb2.pdbreader.symbol;

import ghidra.app.util.bin.format.pdb2.pdbreader.AbstractParsableItem;
import ghidra.app.util.bin.format.pdb2.pdbreader.DelimiterState;
import ghidra.app.util.bin.format.pdb2.pdbreader.PdbByteReader;
import ghidra.app.util.bin.format.pdb2.pdbreader.PdbException;

public class ProcedureFlags
extends AbstractParsableItem {
    private static final int HAS_FRAME_POINTER_PRESENT = 1;
    private static final int HAS_INTERRUPT_RETURN = 2;
    private static final int HAS_FAR_RETURN = 4;
    private static final int DOES_NOT_RETURN = 8;
    private static final int LABEL_NOT_REACHED = 16;
    private static final int HAS_CUSTOM_CALLING_CONVENTION = 32;
    private static final int MARKED_AS_NO_INLINE = 64;
    private static final int HAS_DEBUG_INFORMATION_FOR_OPTIMIZED_CODE = 128;
    private static final int FUNCTION_INDICATION = 255;
    private int flagByte;

    public ProcedureFlags(PdbByteReader reader) throws PdbException {
        this.flagByte = reader.parseUnsignedByteVal();
    }

    @Override
    public void emit(StringBuilder builder) {
        DelimiterState ds = new DelimiterState("", ", ");
        builder.append("Flags: ");
        builder.append(ds.out(this.hasFramePointerPresent(), "Frame Ptr Present"));
        builder.append(ds.out(this.hasInterruptReturn(), "Interrupt"));
        builder.append(ds.out(this.hasFarReturn(), "FAR"));
        builder.append(ds.out(this.doesNotReturn(), "Never Return"));
        builder.append(ds.out(this.labelNotReached(), "Not Reached"));
        builder.append(ds.out(this.hasCustomCallingConvention(), "Custom Calling Convention"));
        builder.append(ds.out(this.markedAsNoInline(), "Do Not Inline"));
        builder.append(ds.out(this.hasDebugInformationForOptimizedCode(), "Optimized Debug Info"));
    }

    public boolean hasFramePointerPresent() {
        return (this.flagByte & 1) != 0;
    }

    public boolean hasInterruptReturn() {
        return (this.flagByte & 2) != 0;
    }

    public boolean hasFarReturn() {
        return (this.flagByte & 4) != 0;
    }

    public boolean doesNotReturn() {
        return (this.flagByte & 8) != 0;
    }

    public boolean labelNotReached() {
        return (this.flagByte & 0x10) != 0;
    }

    public boolean hasCustomCallingConvention() {
        return (this.flagByte & 0x20) != 0;
    }

    public boolean markedAsNoInline() {
        return (this.flagByte & 0x40) != 0;
    }

    public boolean hasDebugInformationForOptimizedCode() {
        return (this.flagByte & 0x80) != 0;
    }

    public boolean hasFunctionIndication() {
        return (this.flagByte & 0xFF) != 0;
    }
}

