/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.debug.service.progress;

import ghidra.app.plugin.core.debug.service.progress.ProgressServicePlugin;
import ghidra.debug.api.progress.MonitorReceiver;
import ghidra.debug.api.progress.ProgressListener;
import ghidra.util.datastruct.ListenerSet;
import ghidra.util.task.CancelledListener;

public class DefaultMonitorReceiver
implements MonitorReceiver {
    private final ProgressServicePlugin plugin;
    private final ListenerSet<CancelledListener> listeners = new ListenerSet(CancelledListener.class, true);
    private final Object lock = new Object();
    private boolean cancelled = false;
    private boolean indeterminate = false;
    private boolean cancelEnabled = true;
    private boolean showProgressValue = true;
    private boolean valid = true;
    private String message = "";
    private long maximum;
    private long progress;

    public DefaultMonitorReceiver(ProgressServicePlugin plugin) {
        this.plugin = plugin;
    }

    public boolean isCancelled() {
        return this.cancelled;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancel() {
        Object object = this.lock;
        synchronized (object) {
            if (this.cancelled) {
                return;
            }
            this.cancelled = true;
        }
        ((CancelledListener)this.listeners.invoke()).cancelled();
        ((ProgressListener)this.plugin.listeners.invoke()).attributeUpdated((MonitorReceiver)this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setShowProgressValue(boolean showProgressValue) {
        Object object = this.lock;
        synchronized (object) {
            if (this.showProgressValue == showProgressValue) {
                return;
            }
            this.showProgressValue = showProgressValue;
        }
        ((ProgressListener)this.plugin.listeners.invoke()).attributeUpdated((MonitorReceiver)this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setMessage(String message) {
        Object object = this.lock;
        synchronized (object) {
            this.message = message == null ? "" : message;
        }
        ((ProgressListener)this.plugin.listeners.invoke()).messageUpdated((MonitorReceiver)this, this.message);
    }

    void reportError(Throwable error) {
        ((ProgressListener)this.plugin.listeners.invoke()).errorReported((MonitorReceiver)this, error);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getMessage() {
        Object object = this.lock;
        synchronized (object) {
            return this.message;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setProgress(long progress) {
        Object object = this.lock;
        synchronized (object) {
            this.progress = progress;
        }
        ((ProgressListener)this.plugin.listeners.invoke()).progressUpdated((MonitorReceiver)this, progress);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void incrementProgress(long amount) {
        long progress;
        Object object = this.lock;
        synchronized (object) {
            this.progress = progress = this.progress + amount;
        }
        ((ProgressListener)this.plugin.listeners.invoke()).progressUpdated((MonitorReceiver)this, progress);
    }

    public long getProgress() {
        return this.progress;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setMaximum(long maximum) {
        Object object = this.lock;
        synchronized (object) {
            if (this.maximum == maximum) {
                return;
            }
            this.maximum = maximum;
        }
        ((ProgressListener)this.plugin.listeners.invoke()).attributeUpdated((MonitorReceiver)this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getMaximum() {
        Object object = this.lock;
        synchronized (object) {
            return this.maximum;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setIndeterminate(boolean indeterminate) {
        Object object = this.lock;
        synchronized (object) {
            if (this.indeterminate == indeterminate) {
                return;
            }
            this.indeterminate = indeterminate;
        }
        ((ProgressListener)this.plugin.listeners.invoke()).attributeUpdated((MonitorReceiver)this);
    }

    public boolean isIndeterminate() {
        return this.indeterminate;
    }

    void addCancelledListener(CancelledListener listener) {
        this.listeners.add((Object)listener);
    }

    void removeCancelledListener(CancelledListener listener) {
        this.listeners.remove((Object)listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setCancelEnabled(boolean cancelEnabled) {
        Object object = this.lock;
        synchronized (object) {
            if (this.cancelEnabled == cancelEnabled) {
                return;
            }
            this.cancelEnabled = cancelEnabled;
        }
        ((ProgressListener)this.plugin.listeners.invoke()).attributeUpdated((MonitorReceiver)this);
    }

    public boolean isCancelEnabled() {
        return this.cancelEnabled;
    }

    public boolean isShowProgressValue() {
        return this.showProgressValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        Object object = this.lock;
        synchronized (object) {
            if (!this.valid) {
                return;
            }
            this.valid = false;
        }
        this.plugin.disposeMonitor(this, ProgressListener.Disposal.CLOSED);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clean() {
        Object object = this.lock;
        synchronized (object) {
            if (!this.valid) {
                return;
            }
            this.valid = false;
        }
        this.plugin.disposeMonitor(this, ProgressListener.Disposal.CLEANED);
    }

    public boolean isValid() {
        return this.valid;
    }
}

