/*
 * Decompiled with CFR 0.152.
 */
package com.tngtech.archunit.freeplane.extension;

import com.tngtech.archunit.ArchConfiguration;
import com.tngtech.archunit.freeplane.extension.ArchitectureViolations;
import com.tngtech.archunit.freeplane.extension.FreeplaneClient;
import com.tngtech.archunit.freeplane.extension.TransferObjectBuilder;
import com.tngtech.archunit.lang.EvaluationResult;
import com.tngtech.archunit.lang.extension.ArchUnitExtension;
import com.tngtech.archunit.lang.extension.EvaluatedRule;
import java.util.Properties;

public class FreeplaneExtension
implements ArchUnitExtension {
    public static final String UNIQUE_IDENTIFIER = "freeplane-archunit-extension";
    private FreeplaneClient freeplaneClient;

    FreeplaneExtension(FreeplaneClient freeplaneClient) {
        this.freeplaneClient = freeplaneClient;
    }

    public FreeplaneExtension() {
        this(null);
    }

    public String getUniqueIdentifier() {
        return UNIQUE_IDENTIFIER;
    }

    public void configure(Properties properties) {
        String portSpec = properties.getProperty("port", "6297");
        int port = Integer.parseInt(portSpec);
        this.freeplaneClient = new FreeplaneClient("localhost", port);
    }

    public void handle(EvaluatedRule evaluatedRule) {
        EvaluationResult result = evaluatedRule.getResult();
        if (!result.hasViolation()) {
            return;
        }
        TransferObjectBuilder transferObjectBuilder = new TransferObjectBuilder();
        result.handleViolations(transferObjectBuilder::handle, new Object[0]);
        ArchitectureViolations architectureViolations = transferObjectBuilder.buildTransferObject(evaluatedRule.getRule().getDescription());
        if (!this.freeplaneClient.sendJson(architectureViolations)) {
            ArchConfiguration.get().configureExtension(UNIQUE_IDENTIFIER).setProperty("enabled", (Object)false);
        }
    }
}

