/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.features.link.mindmapmode.editor;

import com.jgoodies.forms.builder.DefaultFormBuilder;
import com.jgoodies.forms.factories.Paddings;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.Component;
import java.awt.HeadlessException;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.border.Border;
import org.freeplane.core.ui.components.UITools;
import org.freeplane.core.util.TextUtils;
import org.freeplane.features.link.ConnectorModel;
import org.freeplane.features.link.NodeLinks;
import org.freeplane.features.link.mindmapmode.MLinkController;
import org.freeplane.features.link.mindmapmode.editor.ConnectorArrowsControlGroup;
import org.freeplane.features.link.mindmapmode.editor.ConnectorColorControlGroup;
import org.freeplane.features.link.mindmapmode.editor.ConnectorDashControlGroup;
import org.freeplane.features.link.mindmapmode.editor.ConnectorShapeControlGroup;
import org.freeplane.features.link.mindmapmode.editor.ConnectorWidthControlGroup;
import org.freeplane.features.link.mindmapmode.editor.ControlGroup;
import org.freeplane.features.link.mindmapmode.editor.FontNameControlGroup;
import org.freeplane.features.link.mindmapmode.editor.FontSizeControlGroup;
import org.freeplane.features.link.mindmapmode.editor.OpacityControlGroup;
import org.freeplane.features.map.MapModel;
import org.freeplane.features.map.NodeModel;
import org.freeplane.features.styles.IStyle;
import org.freeplane.features.styles.MapStyleModel;
import org.freeplane.features.styles.StyleString;
import org.freeplane.features.styles.mindmapmode.ComboBoxRendererWithTooltip;

public class ConnectorEditorPanel
extends JPanel {
    static final float FONT_SIZE = UITools.getUIFontSize((float)0.8f);
    private static final long serialVersionUID = 1L;
    ControlGroup[] controlGroups;
    private ConnectorModel connector;
    private MLinkController linkController;

    public ConnectorEditorPanel(MLinkController linkController, ConnectorModel connector) throws HeadlessException {
        this.linkController = linkController;
        this.connector = connector;
        this.controlGroups = this.createControlGroups();
        this.addHierarchyListener(new HierarchyListener(){

            @Override
            public void hierarchyChanged(HierarchyEvent e) {
                if (ConnectorEditorPanel.this.isDisplayable()) {
                    ConnectorEditorPanel.this.removeHierarchyListener(this);
                    ConnectorEditorPanel.this.init();
                }
            }
        });
    }

    private ControlGroup[] createControlGroups() {
        return new ControlGroup[]{new ConnectorColorControlGroup(), new OpacityControlGroup(), new ConnectorArrowsControlGroup(), new ConnectorShapeControlGroup(), new ConnectorDashControlGroup(), new ConnectorWidthControlGroup(), new FontNameControlGroup(), new FontSizeControlGroup()};
    }

    private void init() {
        String form = "right:max(20dlu;p), 2dlu, p, 1dlu,right:max(20dlu;p), 4dlu, 80dlu, 7dlu";
        FormLayout rightLayout = new FormLayout("right:max(20dlu;p), 2dlu, p, 1dlu,right:max(20dlu;p), 4dlu, 80dlu, 7dlu", "");
        DefaultFormBuilder formBuilder = new DefaultFormBuilder(rightLayout);
        formBuilder.border((Border)Paddings.DLU2);
        if (!MapStyleModel.isStyleNode((NodeModel)this.connector.getSource())) {
            JComboBox<IStyle> stylesBox = this.createStyleSelector(this.connector);
            formBuilder.append((Component)formBuilder.getComponentFactory().createLabel(TextUtils.getText((String)"style")), 3);
            formBuilder.append(stylesBox, 3);
            formBuilder.nextLine();
        }
        for (ControlGroup controlGroup : this.controlGroups) {
            controlGroup.addControlGroup(formBuilder);
        }
        this.add((Component)formBuilder.getPanel(), "Center");
        this.updateValues();
    }

    public void updateValues() {
        for (ControlGroup controlGroup : this.controlGroups) {
            controlGroup.updateValue(this.connector);
        }
    }

    private JComboBox<IStyle> createStyleSelector(ConnectorModel link) {
        MapModel map = link.getSource().getMap();
        MapStyleModel styleMap = MapStyleModel.getExtension((MapModel)map);
        IStyle[] styles = (IStyle[])styleMap.getStyles().stream().filter(key -> NodeLinks.getSelfConnector((NodeModel)styleMap.getStyleNode(key)).isPresent()).toArray(IStyle[]::new);
        JComboBox<IStyle> stylesBox = new JComboBox<IStyle>(styles);
        stylesBox.setSelectedItem(link.getStyle());
        stylesBox.setPrototypeDisplayValue((IStyle)new StyleString("XXXXXXXXXXXXXXXXXXXXXXXX"));
        stylesBox.setRenderer(new ComboBoxRendererWithTooltip(stylesBox));
        stylesBox.setAlignmentX(0.0f);
        stylesBox.addItemListener(item -> {
            this.linkController.setConnectorStyle(link, (IStyle)stylesBox.getSelectedItem());
            this.updateValues();
        });
        return stylesBox;
    }
}

