/*
 * Decompiled with CFR 0.152.
 */
package org.cryptacular.x509.dn;

import org.cryptacular.CryptUtil;
import org.cryptacular.x509.dn.AttributeType;
import org.cryptacular.x509.dn.StandardAttributeType;
import org.cryptacular.x509.dn.UnknownAttributeType;

public class Attribute {
    private final AttributeType type;
    private final String value;

    public Attribute(String typeOid, String value) {
        CryptUtil.assertNotNullArg(typeOid, "Type OID cannot be null");
        CryptUtil.assertNotNullArg(value, "Value cannot be null");
        StandardAttributeType type = StandardAttributeType.fromOid(typeOid);
        this.type = type != null ? type : new UnknownAttributeType(typeOid);
        this.value = value;
    }

    public Attribute(AttributeType type, String value) {
        this.type = CryptUtil.assertNotNullArg(type, "Type cannot be null");
        this.value = CryptUtil.assertNotNullArg(value, "Value cannot be null");
    }

    public AttributeType getType() {
        return this.type;
    }

    public String getValue() {
        return this.value;
    }
}

