/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.ast.expression;

import java.util.Collections;
import java.util.List;
import lombok.Generated;
import org.opensearch.sql.ast.expression.Literal;
import org.opensearch.sql.ast.expression.SearchExpression;
import org.opensearch.sql.ast.expression.UnresolvedExpression;
import org.opensearch.sql.utils.QueryStringUtils;

public class SearchLiteral
extends SearchExpression {
    private final UnresolvedExpression literal;
    private final boolean isPhrase;

    @Override
    public String toQueryString() {
        if (this.literal instanceof Literal) {
            Literal lit = (Literal)this.literal;
            Object val = lit.getValue();
            if (val instanceof Number) {
                return val.toString();
            }
            if (val instanceof String) {
                String str = (String)val;
                if (this.isPhrase) {
                    str = QueryStringUtils.escapeLuceneSpecialCharacters(str);
                    return "\"" + str + "\"";
                }
                return QueryStringUtils.escapeLuceneSpecialCharacters(str);
            }
        }
        String text = this.literal.toString();
        return QueryStringUtils.escapeLuceneSpecialCharacters(text);
    }

    @Override
    public String toAnonymizedString() {
        return "***";
    }

    public List<? extends UnresolvedExpression> getChild() {
        return Collections.singletonList(this.literal);
    }

    @Generated
    public UnresolvedExpression getLiteral() {
        return this.literal;
    }

    @Generated
    public boolean isPhrase() {
        return this.isPhrase;
    }

    @Generated
    public SearchLiteral(UnresolvedExpression literal, boolean isPhrase) {
        this.literal = literal;
        this.isPhrase = isPhrase;
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SearchLiteral)) {
            return false;
        }
        SearchLiteral other = (SearchLiteral)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isPhrase() != other.isPhrase()) {
            return false;
        }
        UnresolvedExpression this$literal = this.getLiteral();
        UnresolvedExpression other$literal = other.getLiteral();
        return !(this$literal == null ? other$literal != null : !((Object)this$literal).equals(other$literal));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof SearchLiteral;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isPhrase() ? 79 : 97);
        UnresolvedExpression $literal = this.getLiteral();
        result = result * 59 + ($literal == null ? 43 : ((Object)$literal).hashCode());
        return result;
    }

    @Override
    @Generated
    public String toString() {
        return "SearchLiteral(literal=" + String.valueOf(this.getLiteral()) + ", isPhrase=" + this.isPhrase() + ")";
    }
}

