/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.refactoring.rename;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMember;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.util.RadioUpDownListener;
import com.intellij.ui.components.JBBox;
import com.intellij.usageView.UsageViewUtil;
import com.intellij.util.containers.ContainerUtil;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrField;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrAccessorMethod;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrMethod;
import org.jetbrains.plugins.groovy.lang.psi.util.GroovyPropertyUtils;
import org.jetbrains.plugins.groovy.refactoring.GroovyRefactoringBundle;

public final class RenamePropertyUtil {
    private RenamePropertyUtil() {
    }

    public static String getGetterNameByOldName(String propertyName, String oldGetterName) {
        return GroovyPropertyUtils.getAccessorName(oldGetterName.startsWith("is") ? "is" : "get", propertyName);
    }

    public static Pair<List<? extends PsiElement>, String> askToRenameProperty(PsiMember m) {
        PsiClass containingClass;
        String name;
        if (m instanceof GrAccessorMethod) {
            return RenamePropertyUtil.member(((GrAccessorMethod)m).getProperty());
        }
        if (m instanceof GrMethod) {
            name = GroovyPropertyUtils.getPropertyNameByAccessorName(m.getName());
            if (name == null) {
                return RenamePropertyUtil.member(m);
            }
        } else if (m instanceof GrField) {
            name = m.getName();
            if (!((GrField)m).isProperty()) {
                return RenamePropertyUtil.member(m);
            }
        } else {
            return RenamePropertyUtil.member(m);
        }
        if ((containingClass = m.getContainingClass()) == null) {
            return RenamePropertyUtil.member(m);
        }
        boolean isStatic = m.hasModifierProperty("static");
        ArrayList<PsiElement> property = new ArrayList<PsiElement>();
        assert (name != null);
        ContainerUtil.addAll(property, (Object[])GroovyPropertyUtils.getAllGetters(containingClass, name, isStatic, false));
        ContainerUtil.addAll(property, (Object[])GroovyPropertyUtils.getAllSetters(containingClass, name, isStatic, false));
        Iterator iterator2 = property.iterator();
        while (iterator2.hasNext()) {
            if (!(iterator2.next() instanceof GrAccessorMethod)) continue;
            iterator2.remove();
        }
        PsiField field2 = containingClass.findFieldByName(name, false);
        if (field2 != null) {
            property.add((PsiElement)field2);
        }
        if (property.size() == 1) {
            return RenamePropertyUtil.member(m);
        }
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            return RenamePropertyUtil.property(property, name);
        }
        AskDialog dialog = new AskDialog(m);
        dialog.show();
        if (dialog.getExitCode() == 1) {
            return RenamePropertyUtil.cancel();
        }
        if (dialog.renameProperty()) {
            return RenamePropertyUtil.property(property, name);
        }
        return RenamePropertyUtil.member(m);
    }

    private static Pair<List<? extends PsiElement>, String> property(List<PsiElement> list, String name) {
        return Pair.create(list, (Object)name);
    }

    private static Pair<List<? extends PsiElement>, String> cancel() {
        return Pair.create(Collections.emptyList(), null);
    }

    private static Pair<List<? extends PsiElement>, String> member(PsiMember m) {
        return Pair.create(Collections.singletonList(m), null);
    }

    private static class AskDialog
    extends DialogWrapper {
        private JRadioButton myRbRenameMember;
        private JRadioButton myRbRenameProperty;
        private final PsiMember myMember;

        protected AskDialog(PsiMember member) {
            super(member.getProject());
            this.myMember = member;
            this.setTitle(RefactoringBundle.message((String)"select.refactoring.title"));
            this.init();
        }

        protected JComponent createNorthPanel() {
            return new JLabel(RefactoringBundle.message((String)"what.would.you.like.to.do"));
        }

        @Nullable
        private String getPropertyName() {
            if (this.myMember instanceof GrMethod) {
                return GroovyPropertyUtils.getPropertyNameByAccessorName(this.myMember.getName());
            }
            if (this.myMember instanceof GrField) {
                return this.myMember.getName();
            }
            return null;
        }

        protected JComponent createCenterPanel() {
            JPanel panel2 = new JPanel();
            this.myRbRenameMember = new JRadioButton(GroovyRefactoringBundle.message("rename.member", this.getDescription()));
            this.myRbRenameProperty = new JRadioButton(GroovyRefactoringBundle.message("rename.property", this.getPropertyName()));
            ButtonGroup gr = new ButtonGroup();
            gr.add(this.myRbRenameProperty);
            gr.add(this.myRbRenameMember);
            this.myRbRenameProperty.setSelected(true);
            JBBox box = JBBox.createVerticalBox();
            box.add(Box.createVerticalStrut(5));
            box.add((Component)this.myRbRenameProperty);
            box.add((Component)this.myRbRenameMember);
            panel2.add((Component)box, "Center");
            RadioUpDownListener.installOn((JRadioButton[])new JRadioButton[]{this.myRbRenameMember, this.myRbRenameProperty});
            return panel2;
        }

        public JComponent getPreferredFocusedComponent() {
            return this.myRbRenameProperty;
        }

        private String getDescription() {
            return String.format("%s '%s'", UsageViewUtil.getType((PsiElement)this.myMember), this.myMember.getName());
        }

        public boolean renameProperty() {
            return this.myRbRenameProperty.isSelected();
        }
    }
}

