/*
 * Decompiled with CFR 0.152.
 */
package com.shatteredpixel.shatteredpixeldungeon.actors.blobs;

import com.shatteredpixel.shatteredpixeldungeon.Dungeon;
import com.shatteredpixel.shatteredpixeldungeon.actors.Actor;
import com.shatteredpixel.shatteredpixeldungeon.actors.Char;
import com.shatteredpixel.shatteredpixeldungeon.actors.blobs.Blob;
import com.shatteredpixel.shatteredpixeldungeon.effects.BlobEmitter;
import com.shatteredpixel.shatteredpixeldungeon.effects.CellEmitter;
import com.shatteredpixel.shatteredpixeldungeon.effects.particles.ElmoParticle;
import com.shatteredpixel.shatteredpixeldungeon.levels.Level;
import com.shatteredpixel.shatteredpixeldungeon.messages.Messages;
import com.watabou.noosa.audio.Sample;
import com.watabou.utils.Bundle;
import java.util.Arrays;

public class VaultFlameTraps
extends Blob {
    public int[] initialCooldowns;
    public int[] cooldowns;
    private static final String ONE = "one";
    private static final String TWO = "two";

    @Override
    public boolean act() {
        super.act();
        for (int i = 0; i < this.initialCooldowns.length; ++i) {
            if (this.initialCooldowns[i] <= -1) continue;
            if (this.cooldowns[i] <= 0) {
                this.cooldowns[i] = this.initialCooldowns[i];
            }
            int n = i;
            this.cooldowns[n] = this.cooldowns[n] - 1;
            if (this.cooldowns[i] > 0) continue;
            this.seed(Dungeon.level, i, 1);
        }
        return true;
    }

    @Override
    protected void evolve() {
        for (int i = this.area.left; i < this.area.right; ++i) {
            for (int j = this.area.top; j < this.area.bottom; ++j) {
                int cell = i + j * Dungeon.level.width();
                if (this.cur[cell] <= 0) continue;
                Char ch = Actor.findChar(cell);
                if (ch == Dungeon.hero) {
                    Sample.INSTANCE.play("sounds/burning.mp3");
                    ch.sprite.showStatus(0xFF0000, "!!!", new Object[0]);
                }
                if (!Dungeon.level.heroFOV[cell]) continue;
                CellEmitter.get(cell).start(ElmoParticle.FACTORY, 0.02f, 10);
            }
        }
    }

    @Override
    public void seed(Level level, int cell, int amount) {
        super.seed(level, cell, amount);
        if (this.initialCooldowns == null) {
            this.initialCooldowns = new int[level.length()];
            Arrays.fill(this.initialCooldowns, -1);
        }
        if (this.cooldowns == null) {
            this.cooldowns = new int[level.length()];
        }
    }

    @Override
    public void storeInBundle(Bundle bundle) {
        super.storeInBundle(bundle);
        bundle.put(ONE, this.initialCooldowns);
        bundle.put(TWO, this.cooldowns);
    }

    @Override
    public void restoreFromBundle(Bundle bundle) {
        super.restoreFromBundle(bundle);
        this.initialCooldowns = bundle.getIntArray(ONE);
        this.cooldowns = bundle.getIntArray(TWO);
    }

    @Override
    public void use(BlobEmitter emitter) {
        super.use(emitter);
        emitter.bound.set(0.4f, 0.4f, 0.6f, 0.6f);
        emitter.pour(ElmoParticle.FACTORY, 0.3f);
    }

    @Override
    public String tileDesc() {
        return Messages.get(this, "desc", new Object[0]);
    }
}

