/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.jdbc.field;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.SQLException;
import org.firebirdsql.gds.ng.fields.FieldDescriptor;
import org.firebirdsql.jdbc.field.FBField;
import org.firebirdsql.jdbc.field.FieldDataProvider;
import org.jspecify.annotations.NullMarked;

final class FBIntegerField
extends FBField {
    private static final BigDecimal BD_MAX_INT = BigDecimal.valueOf(Integer.MAX_VALUE);
    private static final BigDecimal BD_MIN_INT = BigDecimal.valueOf(Integer.MIN_VALUE);
    private static final BigInteger BI_MAX_INT = BigInteger.valueOf(Integer.MAX_VALUE);
    private static final BigInteger BI_MIN_INT = BigInteger.valueOf(Integer.MIN_VALUE);

    @NullMarked
    FBIntegerField(FieldDescriptor fieldDescriptor, FieldDataProvider dataProvider, int requiredType) throws SQLException {
        super(fieldDescriptor, dataProvider, requiredType);
    }

    @Override
    public Object getObject() throws SQLException {
        if (this.isNull()) {
            return null;
        }
        return this.getInt();
    }

    @Override
    public byte getByte() throws SQLException {
        int value = this.getInt();
        if (value > 127 || value < -128) {
            throw this.outOfRangeGetConversion("byte", value);
        }
        return (byte)value;
    }

    @NullMarked
    private SQLException outOfRangeGetConversion(String type, int value) {
        return this.invalidGetConversion(type, "value %d out of range".formatted(value));
    }

    @Override
    public short getShort() throws SQLException {
        int value = this.getInt();
        if (value > Short.MAX_VALUE || value < Short.MIN_VALUE) {
            throw this.outOfRangeGetConversion("short", value);
        }
        return (short)value;
    }

    @Override
    public int getInt() throws SQLException {
        return this.getDatatypeCoder().decodeInt(this.getFieldData());
    }

    @Override
    public long getLong() throws SQLException {
        return this.getInt();
    }

    @Override
    public float getFloat() throws SQLException {
        return this.getInt();
    }

    @Override
    public double getDouble() throws SQLException {
        return this.getInt();
    }

    @Override
    public BigDecimal getBigDecimal() throws SQLException {
        if (this.isNull()) {
            return null;
        }
        return BigDecimal.valueOf(this.getInt());
    }

    @Override
    public boolean getBoolean() throws SQLException {
        return this.getInt() == 1;
    }

    @Override
    public String getString() throws SQLException {
        if (this.isNull()) {
            return null;
        }
        return String.valueOf(this.getInt());
    }

    @Override
    public BigInteger getBigInteger() throws SQLException {
        if (this.isNull()) {
            return null;
        }
        return BigInteger.valueOf(this.getInt());
    }

    @Override
    public void setString(String value) throws SQLException {
        if (this.setWhenNull(value)) {
            return;
        }
        String string = value.trim();
        try {
            this.setInteger(Integer.parseInt(string));
        }
        catch (NumberFormatException nfex) {
            throw this.invalidSetConversion(String.class, string, (Throwable)nfex);
        }
    }

    @Override
    public void setShort(short value) throws SQLException {
        this.setInteger(value);
    }

    @Override
    public void setBoolean(boolean value) throws SQLException {
        this.setInteger(value ? 1 : 0);
    }

    @Override
    public void setFloat(float value) throws SQLException {
        if (value > 2.1474836E9f || value < -2.1474836E9f) {
            throw this.invalidSetConversion("float", String.format("value %f out of range", Float.valueOf(value)));
        }
        this.setInteger((int)value);
    }

    @Override
    public void setDouble(double value) throws SQLException {
        if (value > 2.147483647E9 || value < -2.147483648E9) {
            throw this.invalidSetConversion("double", String.format("value %f out of range", value));
        }
        this.setInteger((int)value);
    }

    @Override
    public void setLong(long value) throws SQLException {
        if (value > Integer.MAX_VALUE || value < Integer.MIN_VALUE) {
            throw this.invalidSetConversion("long", String.format("value %d out of range", value));
        }
        this.setInteger((int)value);
    }

    @Override
    public void setInteger(int value) throws SQLException {
        this.setFieldData(this.getDatatypeCoder().encodeInt(value));
    }

    @Override
    public void setByte(byte value) throws SQLException {
        this.setInteger(value);
    }

    @Override
    public void setBigDecimal(BigDecimal value) throws SQLException {
        if (this.setWhenNull(value)) {
            return;
        }
        if (value.compareTo(BD_MAX_INT) > 0 || value.compareTo(BD_MIN_INT) < 0) {
            throw this.invalidSetConversion(BigDecimal.class, String.format("value %f out of range", value));
        }
        this.setInteger(value.intValue());
    }

    @Override
    public void setBigInteger(BigInteger value) throws SQLException {
        if (this.setWhenNull(value)) {
            return;
        }
        if (value.compareTo(BI_MAX_INT) > 0 || value.compareTo(BI_MIN_INT) < 0) {
            throw this.invalidSetConversion(BigInteger.class, String.format("value %d out of range", value));
        }
        this.setLong(value.intValueExact());
    }
}

