/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.ermodel.implementation;

import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;
import schemacrawler.ermodel.implementation.AbstractTableBacked;
import schemacrawler.ermodel.model.Entity;
import schemacrawler.ermodel.model.EntityType;
import schemacrawler.ermodel.model.Relationship;
import schemacrawler.schema.Table;

class MutableEntity
extends AbstractTableBacked
implements Entity {
    private static final long serialVersionUID = 3946422106166202467L;
    private final EntityType entityType;
    private final Set<Relationship> relationships;

    public MutableEntity(Table table, EntityType entityType) {
        super(table);
        this.entityType = Objects.requireNonNull(entityType, "No entity type provided");
        this.relationships = new TreeSet<Relationship>();
    }

    @Override
    public Collection<Relationship> getRelationships() {
        return List.copyOf(this.relationships);
    }

    @Override
    public EntityType getType() {
        return this.entityType;
    }

    void addRelationship(Relationship relationship) {
        if (relationship != null) {
            this.relationships.add(relationship);
        }
    }
}

