/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.nfi.backend.panama;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.InvalidArrayIndexException;
import com.oracle.truffle.api.interop.TruffleObject;
import com.oracle.truffle.api.interop.UnknownIdentifierException;
import com.oracle.truffle.api.library.ExportLibrary;
import com.oracle.truffle.api.library.ExportMessage;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.profiles.InlinedBranchProfile;
import com.oracle.truffle.nfi.backend.panama.PanamaNFILanguage;
import com.oracle.truffle.nfi.backend.panama.PanamaSymbol;
import java.lang.foreign.Linker;
import java.lang.foreign.MemorySegment;
import java.lang.foreign.SymbolLookup;
import java.util.Optional;

@ExportLibrary(value=InteropLibrary.class)
final class PanamaLibrary
implements TruffleObject {
    private static final EmptyKeysArray KEYS = new EmptyKeysArray();
    private final SymbolLookup library;

    @CompilerDirectives.TruffleBoundary
    private static SymbolLookup getDefaultLookup() {
        return Linker.nativeLinker().defaultLookup();
    }

    static PanamaLibrary createDefault() {
        return new PanamaLibrary(PanamaLibrary.getDefaultLookup());
    }

    static PanamaLibrary create(SymbolLookup library) {
        assert (library != null);
        return new PanamaLibrary(library);
    }

    private PanamaLibrary(SymbolLookup library) {
        this.library = library;
    }

    @ExportMessage
    boolean hasMembers() {
        return true;
    }

    @ExportMessage
    Object getMembers(boolean includeInternal) {
        return KEYS;
    }

    @ExportMessage
    boolean isMemberReadable(String member) {
        return true;
    }

    @CompilerDirectives.TruffleBoundary
    Optional<MemorySegment> doLookup(String name) {
        return this.library.find(name);
    }

    @ExportMessage
    Object readMember(String symbol, @Bind Node node, @Cached InlinedBranchProfile exception) throws UnknownIdentifierException {
        Optional<MemorySegment> ret = this.doLookup(symbol);
        if (ret.isEmpty()) {
            exception.enter(node);
            throw UnknownIdentifierException.create((String)symbol);
        }
        return new PanamaSymbol(ret.get());
    }

    @ExportMessage
    boolean hasLanguage() {
        return true;
    }

    @ExportMessage
    Class<? extends TruffleLanguage<?>> getLanguage() {
        return PanamaNFILanguage.class;
    }

    @ExportMessage
    @CompilerDirectives.TruffleBoundary
    Object toDisplayString(boolean allowSideEffects) {
        return "PanamaLibrary(" + String.valueOf(this.library) + ")";
    }

    @ExportLibrary(value=InteropLibrary.class)
    static final class EmptyKeysArray
    implements TruffleObject {
        EmptyKeysArray() {
        }

        @ExportMessage
        boolean hasArrayElements() {
            return true;
        }

        @ExportMessage
        long getArraySize() {
            return 0L;
        }

        @ExportMessage
        boolean isArrayElementReadable(long index) {
            return false;
        }

        @ExportMessage
        Object readArrayElement(long index) throws InvalidArrayIndexException {
            throw InvalidArrayIndexException.create((long)index);
        }
    }
}

