/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import net.sourceforge.plantuml.security.SFile;
import net.sourceforge.plantuml.utils.Log;

public class FileUtils {
    private static AtomicInteger counter;
    private static final int DISCARD_BUFFER_SIZE = 65536;

    public static void resetCounter() {
        counter = new AtomicInteger(0);
    }

    public static String readSvg(SFile svgFile) throws IOException {
        BufferedReader br = svgFile.openBufferedReader();
        if (br == null) {
            return null;
        }
        return FileUtils.readSvg(br, false, true);
    }

    public static String readSvg(InputStream is) throws IOException {
        BufferedReader br = new BufferedReader(new InputStreamReader(is));
        return FileUtils.readSvg(br, false, false);
    }

    public static void copyInternal(InputStream fis, OutputStream fos, boolean close) throws IOException {
        int len;
        byte[] buf = new byte[10240];
        while ((len = fis.read(buf)) > 0) {
            fos.write(buf, 0, len);
        }
        if (close) {
            fos.close();
            fis.close();
        }
    }

    private static String readSvg(BufferedReader br, boolean withNewline, boolean withClose) throws IOException {
        String s;
        StringBuilder sb = new StringBuilder();
        while ((s = br.readLine()) != null) {
            sb.append(s);
            if (!withNewline) continue;
            sb.append("\n");
        }
        if (withClose) {
            br.close();
        }
        return sb.toString();
    }

    public static String readText(InputStream is) throws IOException {
        BufferedReader br = new BufferedReader(new InputStreamReader(is));
        return FileUtils.readSvg(br, true, true);
    }

    public static File createTempFileLegacy(String prefix, String suffix) throws IOException {
        File f;
        if (!suffix.startsWith(".")) {
            throw new IllegalArgumentException();
        }
        Objects.requireNonNull(prefix);
        if (counter == null) {
            f = File.createTempFile(prefix, suffix);
        } else {
            String name = prefix + counter.addAndGet(1) + suffix;
            f = new File(name);
        }
        Log.info(() -> "Creating temporary file: " + f);
        f.deleteOnExit();
        return f;
    }

    public static SFile createTempFile(String prefix, String suffix) throws IOException {
        SFile f;
        if (!suffix.startsWith(".")) {
            throw new IllegalArgumentException();
        }
        Objects.requireNonNull(prefix);
        if (counter == null) {
            f = SFile.createTempFile(prefix, suffix);
        } else {
            String name = prefix + counter.addAndGet(1) + suffix;
            f = new SFile(name);
        }
        Log.info(() -> "Creating temporary file: " + f);
        f.deleteOnExit();
        return f;
    }

    public static void copyToFile(SFile src, SFile dest) throws IOException {
        InputStream fis;
        if (dest.isDirectory()) {
            dest = dest.file(src.getName());
        }
        if ((fis = src.openFile()) == null) {
            throw new FileNotFoundException();
        }
        BufferedOutputStream fos = dest.createBufferedOutputStream();
        FileUtils.copyInternal(fis, fos, true);
    }

    public static void copyToStream(SFile src, OutputStream os) throws IOException {
        InputStream fis = src.openFile();
        if (fis == null) {
            throw new FileNotFoundException();
        }
        BufferedOutputStream fos = new BufferedOutputStream(os);
        FileUtils.copyInternal(fis, fos, true);
    }

    public static void copyToStream(File src, OutputStream os) throws IOException {
        BufferedInputStream fis = new BufferedInputStream(new FileInputStream(src));
        BufferedOutputStream fos = new BufferedOutputStream(os);
        FileUtils.copyInternal(fis, fos, true);
    }

    public static void copyToStream(InputStream is, OutputStream os) throws IOException {
        BufferedInputStream fis = new BufferedInputStream(is);
        BufferedOutputStream fos = new BufferedOutputStream(os);
        FileUtils.copyInternal(fis, fos, true);
    }

    public static byte[] copyToByteArray(InputStream is) throws IOException {
        try (BufferedInputStream bis = new BufferedInputStream(is);){
            byte[] byArray;
            try (ByteArrayOutputStream bos = new ByteArrayOutputStream();){
                FileUtils.copyInternal(bis, bos, true);
                byArray = bos.toByteArray();
            }
            return byArray;
        }
    }

    public static void copyToFile(byte[] src, SFile dest) throws IOException {
        try (BufferedOutputStream fos = dest.createBufferedOutputStream();){
            ((OutputStream)fos).write(src);
        }
    }

    public static String readFile(SFile svgFile) throws IOException {
        BufferedReader br = svgFile.openBufferedReader();
        if (br == null) {
            return null;
        }
        return FileUtils.readSvg(br, true, true);
    }

    public static List<String> readStrings(InputStream is) throws IOException {
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(is, StandardCharsets.UTF_8));){
            List<String> list = reader.lines().collect(Collectors.toList());
            return list;
        }
    }

    public static byte[] readExactly(InputStream in, int n) throws IOException {
        int read;
        if (n < 0) {
            throw new IllegalArgumentException("n must be >= 0");
        }
        byte[] data = new byte[n];
        for (int offset = 0; offset < n; offset += read) {
            read = in.read(data, offset, n - offset);
            if (read != -1) continue;
            throw new IOException("End of stream reached after reading " + offset + " bytes (expected " + n + ")");
        }
        return data;
    }

    public static String readAllBytes(InputStream in) throws IOException {
        int read;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        byte[] buffer = new byte[8192];
        while ((read = in.read(buffer)) != -1) {
            baos.write(buffer, 0, read);
        }
        return new String(baos.toByteArray(), StandardCharsets.UTF_8);
    }
}

