/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch.ingest;

import jakarta.json.stream.JsonGenerator;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.ObjectBuilderDeserializer;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.opensearch.ingest.Processor;
import org.opensearch.client.opensearch.ingest.ProcessorBase;
import org.opensearch.client.opensearch.ingest.ProcessorVariant;
import org.opensearch.client.opensearch.ingest.ShapeType;
import org.opensearch.client.util.ApiTypeHelper;
import org.opensearch.client.util.CopyableBuilder;
import org.opensearch.client.util.ObjectBuilder;
import org.opensearch.client.util.ToCopyableBuilder;

@JsonpDeserializable
public class CircleProcessor
extends ProcessorBase
implements ProcessorVariant,
ToCopyableBuilder<Builder, CircleProcessor> {
    private final double errorDistance;
    @Nonnull
    private final String field;
    @Nullable
    private final Boolean ignoreMissing;
    @Nonnull
    private final ShapeType shapeType;
    @Nullable
    private final String targetField;
    public static final JsonpDeserializer<CircleProcessor> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, CircleProcessor::setupCircleProcessorDeserializer);

    private CircleProcessor(Builder builder) {
        super(builder);
        this.errorDistance = ApiTypeHelper.requireNonNull(builder.errorDistance, this, "errorDistance");
        this.field = ApiTypeHelper.requireNonNull(builder.field, this, "field");
        this.ignoreMissing = builder.ignoreMissing;
        this.shapeType = ApiTypeHelper.requireNonNull(builder.shapeType, this, "shapeType");
        this.targetField = builder.targetField;
    }

    public static CircleProcessor of(Function<Builder, ObjectBuilder<CircleProcessor>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Override
    public Processor.Kind _processorKind() {
        return Processor.Kind.Circle;
    }

    public final double errorDistance() {
        return this.errorDistance;
    }

    @Nonnull
    public final String field() {
        return this.field;
    }

    @Nullable
    public final Boolean ignoreMissing() {
        return this.ignoreMissing;
    }

    @Nonnull
    public final ShapeType shapeType() {
        return this.shapeType;
    }

    @Nullable
    public final String targetField() {
        return this.targetField;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        super.serializeInternal(generator, mapper);
        generator.writeKey("error_distance");
        generator.write(this.errorDistance);
        generator.writeKey("field");
        generator.write(this.field);
        if (this.ignoreMissing != null) {
            generator.writeKey("ignore_missing");
            generator.write(this.ignoreMissing.booleanValue());
        }
        generator.writeKey("shape_type");
        this.shapeType.serialize(generator, mapper);
        if (this.targetField != null) {
            generator.writeKey("target_field");
            generator.write(this.targetField);
        }
    }

    @Override
    @Nonnull
    public Builder toBuilder() {
        return new Builder(this);
    }

    @Nonnull
    public static Builder builder() {
        return new Builder();
    }

    protected static void setupCircleProcessorDeserializer(ObjectDeserializer<Builder> op) {
        CircleProcessor.setupProcessorBaseDeserializer(op);
        op.add(Builder::errorDistance, JsonpDeserializer.doubleDeserializer(), "error_distance");
        op.add(Builder::field, JsonpDeserializer.stringDeserializer(), "field");
        op.add(Builder::ignoreMissing, JsonpDeserializer.booleanDeserializer(), "ignore_missing");
        op.add(Builder::shapeType, ShapeType._DESERIALIZER, "shape_type");
        op.add(Builder::targetField, JsonpDeserializer.stringDeserializer(), "target_field");
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + Double.hashCode(this.errorDistance);
        result = 31 * result + this.field.hashCode();
        result = 31 * result + Objects.hashCode(this.ignoreMissing);
        result = 31 * result + this.shapeType.hashCode();
        result = 31 * result + Objects.hashCode(this.targetField);
        return result;
    }

    @Override
    public boolean equals(Object o) {
        if (!super.equals(o)) {
            return false;
        }
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CircleProcessor other = (CircleProcessor)o;
        return this.errorDistance == other.errorDistance && this.field.equals(other.field) && Objects.equals(this.ignoreMissing, other.ignoreMissing) && this.shapeType.equals(other.shapeType) && Objects.equals(this.targetField, other.targetField);
    }

    public static class Builder
    extends ProcessorBase.AbstractBuilder<Builder>
    implements CopyableBuilder<Builder, CircleProcessor> {
        private Double errorDistance;
        private String field;
        @Nullable
        private Boolean ignoreMissing;
        private ShapeType shapeType;
        @Nullable
        private String targetField;

        public Builder() {
        }

        private Builder(CircleProcessor o) {
            super(o);
            this.errorDistance = o.errorDistance;
            this.field = o.field;
            this.ignoreMissing = o.ignoreMissing;
            this.shapeType = o.shapeType;
            this.targetField = o.targetField;
        }

        private Builder(Builder o) {
            super(o);
            this.errorDistance = o.errorDistance;
            this.field = o.field;
            this.ignoreMissing = o.ignoreMissing;
            this.shapeType = o.shapeType;
            this.targetField = o.targetField;
        }

        @Override
        @Nonnull
        public Builder copy() {
            return new Builder(this);
        }

        @Override
        @Nonnull
        protected Builder self() {
            return this;
        }

        @Nonnull
        public final Builder errorDistance(double value) {
            this.errorDistance = value;
            return this;
        }

        @Nonnull
        public final Builder field(String value) {
            this.field = value;
            return this;
        }

        @Nonnull
        public final Builder ignoreMissing(@Nullable Boolean value) {
            this.ignoreMissing = value;
            return this;
        }

        @Nonnull
        public final Builder shapeType(ShapeType value) {
            this.shapeType = value;
            return this;
        }

        @Nonnull
        public final Builder targetField(@Nullable String value) {
            this.targetField = value;
            return this;
        }

        @Override
        @Nonnull
        public CircleProcessor build() {
            this._checkSingleUse();
            return new CircleProcessor(this);
        }
    }
}

