"use strict";

function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
Object.defineProperty(exports, "__esModule", {
  value: true
});
Object.defineProperty(exports, "EuiDataGridCellButtons", {
  enumerable: true,
  get: function get() {
    return _data_grid_cell_buttons.EuiDataGridCellButtons;
  }
});
exports.OuiDataGridCellButtons = void 0;
var _react = _interopRequireWildcard(require("react"));
var _classnames = _interopRequireDefault(require("classnames"));
var _i18n = require("../i18n");
var _button_icon = require("../button/button_icon");
var _data_grid_cell_buttons = require("../../eui_components/datagrid/data_grid_cell_buttons");
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
function _interopRequireWildcard(e, t) { if ("function" == typeof WeakMap) var r = new WeakMap(), n = new WeakMap(); return (_interopRequireWildcard = function _interopRequireWildcard(e, t) { if (!t && e && e.__esModule) return e; var o, i, f = { __proto__: null, default: e }; if (null === e || "object" != _typeof(e) && "function" != typeof e) return f; if (o = t ? n : r) { if (o.has(e)) return o.get(e); o.set(e, f); } for (var _t in e) { "default" !== _t && {}.hasOwnProperty.call(e, _t) && ((i = (o = Object.defineProperty) && Object.getOwnPropertyDescriptor(e, _t)) && (i.get || i.set) ? o(f, _t, i) : f[_t] = e[_t]); } return f; })(e, t); }
function _toConsumableArray(r) { return _arrayWithoutHoles(r) || _iterableToArray(r) || _unsupportedIterableToArray(r) || _nonIterableSpread(); }
function _nonIterableSpread() { throw new TypeError("Invalid attempt to spread non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _unsupportedIterableToArray(r, a) { if (r) { if ("string" == typeof r) return _arrayLikeToArray(r, a); var t = {}.toString.call(r).slice(8, -1); return "Object" === t && r.constructor && (t = r.constructor.name), "Map" === t || "Set" === t ? Array.from(r) : "Arguments" === t || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(t) ? _arrayLikeToArray(r, a) : void 0; } }
function _iterableToArray(r) { if ("undefined" != typeof Symbol && null != r[Symbol.iterator] || null != r["@@iterator"]) return Array.from(r); }
function _arrayWithoutHoles(r) { if (Array.isArray(r)) return _arrayLikeToArray(r); }
function _arrayLikeToArray(r, a) { (null == a || a > r.length) && (a = r.length); for (var e = 0, n = Array(a); e < a; e++) { n[e] = r[e]; } return n; }
function _extends() { return _extends = Object.assign ? Object.assign.bind() : function (n) { for (var e = 1; e < arguments.length; e++) { var t = arguments[e]; for (var r in t) { ({}).hasOwnProperty.call(t, r) && (n[r] = t[r]); } } return n; }, _extends.apply(null, arguments); } /*
 * SPDX-License-Identifier: Apache-2.0
 *
 * The OpenSearch Contributors require contributions made to
 * this file be licensed under the Apache-2.0 license or a
 * compatible open source license.
 *
 * Modifications Copyright OpenSearch Contributors. See
 * GitHub history for details.
 */ /*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
var OuiDataGridCellButtons = function OuiDataGridCellButtons(_ref) {
  var popoverIsOpen = _ref.popoverIsOpen,
    closePopover = _ref.closePopover,
    onExpandClick = _ref.onExpandClick,
    column = _ref.column,
    rowIndex = _ref.rowIndex;
  var buttonIconClasses = (0, _classnames.default)('ouiDataGridRowCell__expandButtonIcon', {
    'ouiDataGridRowCell__expandButtonIcon-isActive': popoverIsOpen
  });
  var buttonClasses = (0, _classnames.default)('ouiDataGridRowCell__expandButton', {
    'ouiDataGridRowCell__expandButton-isActive': popoverIsOpen
  });
  var expandButton = /*#__PURE__*/_react.default.createElement(_i18n.OuiI18n, {
    key: 'expand',
    token: "ouiDataGridCellButtons.expandButtonTitle",
    default: "Click or hit enter to interact with cell content"
  }, function (expandButtonTitle) {
    return /*#__PURE__*/_react.default.createElement(_button_icon.OuiButtonIcon, {
      display: "fill",
      className: buttonIconClasses,
      color: "primary",
      iconSize: "s",
      iconType: "expandMini",
      "aria-hidden": true,
      onClick: onExpandClick,
      title: expandButtonTitle
    });
  });
  var additionalButtons = (0, _react.useMemo)(function () {
    var ButtonComponent = function ButtonComponent(props) {
      return /*#__PURE__*/_react.default.createElement(_button_icon.OuiButtonIcon, _extends({}, props, {
        "aria-hidden": true,
        className: "ouiDataGridRowCell__actionButtonIcon",
        iconSize: "s"
      }));
    };
    return column && Array.isArray(column.cellActions) ? column.cellActions.map(function (Action, idx) {
      // React is more permissible than the TS types indicate
      var CellButtonElement = Action;
      return /*#__PURE__*/_react.default.createElement(CellButtonElement, {
        key: idx,
        rowIndex: rowIndex,
        columnId: column.id,
        Component: ButtonComponent,
        isExpanded: false,
        closePopover: closePopover
      });
    }) : [];
  }, [column, rowIndex, closePopover]);
  return /*#__PURE__*/_react.default.createElement("div", {
    className: buttonClasses
  }, [].concat(_toConsumableArray(additionalButtons), [expandButton]));
};

/* OUI -> EUI Aliases: Build-Time */
exports.OuiDataGridCellButtons = OuiDataGridCellButtons;