/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.timeseries.model;

import com.google.common.collect.ImmutableList;
import java.util.List;

public enum TaskState {
    CREATED("Created"),
    INIT("Init"),
    RUNNING("Running"),
    FAILED("Failed"),
    STOPPED("Stopped"),
    FINISHED("Finished"),
    INIT_ERROR("Error init"),
    ERROR("Error"),
    AWAITING_DATA_TO_INIT("Awaiting data to init"),
    AWAITING_DATA_TO_RESTART("Awaiting data to restart"),
    INIT_TEST("Initializing test"),
    TEST_COMPLETE("Test complete"),
    INIT_TEST_FAILED("Initializing test failed"),
    INACTIVE("Inactive"),
    INACTIVE_STOPPED("Inactive stopped"),
    INACTIVE_NOT_STARTED("Inactive not started"),
    FORECAST_FAILURE("forecast failure");

    private final String description;
    public static List<String> NOT_ENDED_STATES;

    private TaskState(String description) {
        this.description = description;
    }

    public String getDescription() {
        return this.description;
    }

    public static boolean isAwaitState(String state) {
        return AWAITING_DATA_TO_INIT.name().equals(state) || AWAITING_DATA_TO_RESTART.name().equals(state);
    }

    public static boolean isForecastErrorState(String state) {
        return INIT_ERROR.name().equals(state) || FORECAST_FAILURE.name().equals(state);
    }

    static {
        NOT_ENDED_STATES = ImmutableList.of((Object)CREATED.name(), (Object)INIT.name(), (Object)RUNNING.name(), (Object)INIT_TEST.name(), (Object)AWAITING_DATA_TO_INIT.name(), (Object)AWAITING_DATA_TO_RESTART.name(), (Object)FORECAST_FAILURE.name());
    }
}

