/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.expression.function;

import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.PriorityQueue;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.lang3.tuple.Pair;
import org.opensearch.sql.exception.ExpressionEvaluationException;
import org.opensearch.sql.expression.function.FunctionBuilder;
import org.opensearch.sql.expression.function.FunctionName;
import org.opensearch.sql.expression.function.FunctionResolver;
import org.opensearch.sql.expression.function.FunctionSignature;

public class DefaultFunctionResolver
implements FunctionResolver {
    private final FunctionName functionName;
    private final Map<FunctionSignature, FunctionBuilder> functionBundle;

    @Override
    public Pair<FunctionSignature, FunctionBuilder> resolve(FunctionSignature unresolvedSignature) {
        PriorityQueue functionMatchQueue = new PriorityQueue(Map.Entry.comparingByKey());
        for (FunctionSignature functionSignature : this.functionBundle.keySet()) {
            functionMatchQueue.add(new AbstractMap.SimpleEntry<Integer, FunctionSignature>(unresolvedSignature.match(functionSignature), functionSignature));
        }
        Map.Entry bestMatchEntry = functionMatchQueue.peek();
        if (FunctionSignature.isVarArgFunction(((FunctionSignature)bestMatchEntry.getValue()).getParamTypeList()) && (unresolvedSignature.getParamTypeList().isEmpty() || unresolvedSignature.getParamTypeList().size() > 9)) {
            throw new ExpressionEvaluationException(String.format("%s function expected 1-9 arguments, but got %d", this.functionName, unresolvedSignature.getParamTypeList().size()));
        }
        if (FunctionSignature.NOT_MATCH.equals(bestMatchEntry.getKey()) && !FunctionSignature.isVarArgFunction(((FunctionSignature)bestMatchEntry.getValue()).getParamTypeList())) {
            throw new ExpressionEvaluationException(String.format("%s function expected %s, but got %s", this.functionName, this.formatFunctions(this.functionBundle.keySet()), unresolvedSignature.formatTypes()));
        }
        FunctionSignature resolvedSignature = (FunctionSignature)bestMatchEntry.getValue();
        return Pair.of((Object)resolvedSignature, (Object)this.functionBundle.get(resolvedSignature));
    }

    private String formatFunctions(Set<FunctionSignature> functionSignatures) {
        return functionSignatures.stream().map(FunctionSignature::formatTypes).collect(Collectors.joining(",", "{", "}"));
    }

    @Generated
    public static DefaultFunctionResolverBuilder builder() {
        return new DefaultFunctionResolverBuilder();
    }

    @Generated
    public DefaultFunctionResolver(FunctionName functionName, Map<FunctionSignature, FunctionBuilder> functionBundle) {
        this.functionName = functionName;
        this.functionBundle = functionBundle;
    }

    @Override
    @Generated
    public FunctionName getFunctionName() {
        return this.functionName;
    }

    @Generated
    public static class DefaultFunctionResolverBuilder {
        @Generated
        private FunctionName functionName;
        @Generated
        private ArrayList<FunctionSignature> functionBundle$key;
        @Generated
        private ArrayList<FunctionBuilder> functionBundle$value;

        @Generated
        DefaultFunctionResolverBuilder() {
        }

        @Generated
        public DefaultFunctionResolverBuilder functionName(FunctionName functionName) {
            this.functionName = functionName;
            return this;
        }

        @Generated
        public DefaultFunctionResolverBuilder functionBundle(FunctionSignature functionBundleKey, FunctionBuilder functionBundleValue) {
            if (this.functionBundle$key == null) {
                this.functionBundle$key = new ArrayList();
                this.functionBundle$value = new ArrayList();
            }
            this.functionBundle$key.add(functionBundleKey);
            this.functionBundle$value.add(functionBundleValue);
            return this;
        }

        @Generated
        public DefaultFunctionResolverBuilder functionBundle(Map<? extends FunctionSignature, ? extends FunctionBuilder> functionBundle) {
            if (functionBundle == null) {
                throw new NullPointerException("functionBundle cannot be null");
            }
            if (this.functionBundle$key == null) {
                this.functionBundle$key = new ArrayList();
                this.functionBundle$value = new ArrayList();
            }
            for (Map.Entry<? extends FunctionSignature, ? extends FunctionBuilder> $lombokEntry : functionBundle.entrySet()) {
                this.functionBundle$key.add($lombokEntry.getKey());
                this.functionBundle$value.add($lombokEntry.getValue());
            }
            return this;
        }

        @Generated
        public DefaultFunctionResolverBuilder clearFunctionBundle() {
            if (this.functionBundle$key != null) {
                this.functionBundle$key.clear();
                this.functionBundle$value.clear();
            }
            return this;
        }

        @Generated
        public DefaultFunctionResolver build() {
            Map<FunctionSignature, FunctionBuilder> functionBundle;
            switch (this.functionBundle$key == null ? 0 : this.functionBundle$key.size()) {
                case 0: {
                    functionBundle = Collections.emptyMap();
                    break;
                }
                case 1: {
                    functionBundle = Collections.singletonMap(this.functionBundle$key.get(0), this.functionBundle$value.get(0));
                    break;
                }
                default: {
                    functionBundle = new LinkedHashMap<FunctionSignature, FunctionBuilder>(this.functionBundle$key.size() < 0x40000000 ? 1 + this.functionBundle$key.size() + (this.functionBundle$key.size() - 3) / 3 : Integer.MAX_VALUE);
                    for (int $i = 0; $i < this.functionBundle$key.size(); ++$i) {
                        functionBundle.put(this.functionBundle$key.get($i), this.functionBundle$value.get($i));
                    }
                    functionBundle = Collections.unmodifiableMap(functionBundle);
                }
            }
            return new DefaultFunctionResolver(this.functionName, functionBundle);
        }

        @Generated
        public String toString() {
            return "DefaultFunctionResolver.DefaultFunctionResolverBuilder(functionName=" + String.valueOf(this.functionName) + ", functionBundle$key=" + String.valueOf(this.functionBundle$key) + ", functionBundle$value=" + String.valueOf(this.functionBundle$value) + ")";
        }
    }
}

