# -*- coding: binary -*-

module Msf::Exploit::Remote::HTTP::Moodle::URIs
  # Returns the Moodle Login URL
  #
  # @return [String] Moodle Login URL
  def moodle_url_login
    normalize_uri(target_uri.path, 'login', 'index.php')
  end

  # Returns the Moodle Loginas URL
  #
  # @return [String] Moodle Login URL
  def moodle_url_loginas
    normalize_uri(target_uri.path, 'course', 'loginas.php')
  end

  # Returns the Moodle AJAX Course Enrollment URL
  #
  # @return [String] Moodle AJAX course enrolment URL
  def moodle_enrol_ajax
    normalize_uri(target_uri.path, 'enrol', 'manual', 'ajax.php')
  end

  # Returns the Moodle Ajax Service URL
  #
  # @return [String] Moodle Ajax Service URL
  def moodle_ajax_service
    normalize_uri(target_uri.path, 'lib', 'ajax', 'service.php')
  end

  # Returns the Moodle User Home URL
  #
  # @return [String] Moodle User Home URL
  def moodle_user_home
    normalize_uri(target_uri.path, 'user', 'index.php')
  end

  # Returns the Moodle Admin Addon Installation URL
  #
  # @return [String] Moodle admin addon installation URL
  def moodle_admin_addon_install
    normalize_uri(target_uri.path, 'admin', 'tool', 'installaddon', 'index.php')
  end
end
