/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testFramework.bucketing;

import com.intellij.TestCaseLoader;
import com.intellij.testFramework.bucketing.BucketingScheme;
import com.intellij.testFramework.bucketing.HashingBucketingScheme;
import com.intellij.testFramework.bucketing.TestsDurationBucketingUtils;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@ApiStatus.Internal
public class TestsDurationBucketingScheme
implements BucketingScheme {
    private List<TestsDurationBucketingUtils.BucketFilter> myBucketFilters;

    @Override
    public void initialize() {
        if (this.myBucketFilters != null && !this.myBucketFilters.isEmpty()) {
            return;
        }
        System.out.println("Tests duration bucketing initialization started ...");
        long start = System.nanoTime();
        List<Class<?>> testCaseClasses = TestCaseLoader.loadClassesForWarmup();
        Set<String> classes = testCaseClasses.stream().map(Class::getName).collect(Collectors.toSet());
        this.myBucketFilters = TestsDurationBucketingUtils.calculateBucketFilters(TestCaseLoader.getCommonTestClassesFilterArgs(), classes);
        long durationNs = System.nanoTime() - start;
        System.out.printf("Tests duration bucketing initialization finished in %d ms.%n", TimeUnit.NANOSECONDS.toMillis(durationNs));
    }

    @Override
    public boolean matchesCurrentBucket(@NotNull String testIdentifier) {
        if (testIdentifier == null) {
            TestsDurationBucketingScheme.$$$reportNull$$$0(0);
        }
        String packageName = StringsKt.substringBeforeLast((String)testIdentifier, (char)'.', (String)"");
        for (TestsDurationBucketingUtils.BucketFilter filter : this.myBucketFilters) {
            if (!filter.getPackageClasses().containsKey(packageName)) continue;
            TestsDurationBucketingUtils.BucketClassFilter classFilter = filter.getPackageClasses().get(packageName);
            if (classFilter == null) {
                return filter.getIndex() == TestCaseLoader.TEST_RUNNER_INDEX;
            }
            if (!classFilter.getClasses().contains(testIdentifier)) continue;
            return filter.getIndex() == TestCaseLoader.TEST_RUNNER_INDEX;
        }
        System.err.println("Fallback to default bucketing for: " + testIdentifier);
        return HashingBucketingScheme.matchesCurrentBucketViaHashing(testIdentifier);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "testIdentifier", "com/intellij/testFramework/bucketing/TestsDurationBucketingScheme", "matchesCurrentBucket"));
    }
}

