/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.swing.hierarchy;

import java.awt.Component;
import java.awt.Container;
import java.awt.Window;
import java.util.ArrayList;
import java.util.Collection;
import org.assertj.core.util.Lists;
import org.assertj.core.util.VisibleForTesting;
import org.assertj.swing.annotation.RunsInCurrentThread;
import org.assertj.swing.awt.AWT;
import org.assertj.swing.dependency.jsr305.Nonnull;
import org.assertj.swing.hierarchy.ChildrenFinder;
import org.assertj.swing.hierarchy.ComponentHierarchy;
import org.assertj.swing.hierarchy.ParentFinder;
import org.assertj.swing.monitor.WindowMonitor;

public class ExistingHierarchy
implements ComponentHierarchy {
    private static WindowMonitor windowMonitor = WindowMonitor.instance();
    private final ParentFinder parentFinder;
    private final ChildrenFinder childrenFinder;

    public ExistingHierarchy() {
        this(new ParentFinder(), new ChildrenFinder());
    }

    @VisibleForTesting
    ExistingHierarchy(@Nonnull ParentFinder parentFinder, @Nonnull ChildrenFinder childrenFinder) {
        this.parentFinder = parentFinder;
        this.childrenFinder = childrenFinder;
    }

    @Override
    @Nonnull
    public Collection<Container> roots() {
        ArrayList roots = Lists.newArrayList();
        for (Window w : windowMonitor.rootWindows()) {
            roots.add(w);
        }
        return roots;
    }

    @Override
    @RunsInCurrentThread
    public Container parentOf(@Nonnull Component c) {
        return this.parentFinder.parentOf(c);
    }

    @Override
    public boolean contains(@Nonnull Component c) {
        return true;
    }

    @Override
    @Nonnull
    @RunsInCurrentThread
    public Collection<Component> childrenOf(@Nonnull Component c) {
        return this.childrenFinder.childrenOf(c);
    }

    @Override
    @RunsInCurrentThread
    public void dispose(@Nonnull Window w) {
        if (AWT.isAppletViewer(w)) {
            return;
        }
        for (Window owned : w.getOwnedWindows()) {
            if (owned == null) continue;
            this.dispose(owned);
        }
        if (AWT.isSharedInvisibleFrame(w)) {
            return;
        }
        w.dispose();
    }

    @Nonnull
    ParentFinder parentFinder() {
        return this.parentFinder;
    }

    @Nonnull
    ChildrenFinder childrenFinder() {
        return this.childrenFinder;
    }
}

