/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.checkin;

import com.intellij.CodeStyleBundle;
import com.intellij.codeInsight.actions.AbstractLayoutCodeProcessor;
import com.intellij.codeInsight.actions.ReformatCodeProcessor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.VcsConfiguration;
import com.intellij.openapi.vcs.changes.ui.BooleanCommitOption;
import com.intellij.openapi.vcs.checkin.CheckinHandler;
import com.intellij.openapi.vcs.checkin.CheckinHandlerUtil;
import com.intellij.openapi.vcs.checkin.CodeProcessorCheckinHandler;
import com.intellij.openapi.vcs.ui.RefreshableOnComponent;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.MutablePropertyReference0Impl;
import kotlin.reflect.KMutableProperty0;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u0006\u001a\u00020\u0007H\u0016J\b\u0010\b\u001a\u00020\tH\u0016J\b\u0010\n\u001a\u00020\u000bH\u0014J\u0016\u0010\f\u001a\u00020\r2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fH\u0014\u00a8\u0006\u0011"}, d2={"Lcom/intellij/openapi/vcs/checkin/ReformatBeforeCheckinHandler;", "Lcom/intellij/openapi/vcs/checkin/CodeProcessorCheckinHandler;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "getBeforeCheckinConfigurationPanel", "Lcom/intellij/openapi/vcs/ui/RefreshableOnComponent;", "isEnabled", "", "getProgressMessage", "", "createCodeProcessor", "Lcom/intellij/codeInsight/actions/AbstractLayoutCodeProcessor;", "files", "", "Lcom/intellij/openapi/vfs/VirtualFile;", "intellij.platform.vcs.impl.lang"})
@ApiStatus.Internal
public final class ReformatBeforeCheckinHandler
extends CodeProcessorCheckinHandler {
    public ReformatBeforeCheckinHandler(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        super(project);
    }

    @NotNull
    public RefreshableOnComponent getBeforeCheckinConfigurationPanel() {
        Project project = this.getProject();
        CheckinHandler checkinHandler = this;
        String string = VcsBundle.message((String)"checkbox.checkin.options.reformat.code", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        return BooleanCommitOption.Companion.create(project, checkinHandler, true, string, (KMutableProperty0)new MutablePropertyReference0Impl(this.getSettings()){

            public Object get() {
                return ((VcsConfiguration)this.receiver).REFORMAT_BEFORE_PROJECT_COMMIT;
            }

            public void set(Object value) {
                ((VcsConfiguration)this.receiver).REFORMAT_BEFORE_PROJECT_COMMIT = (Boolean)value;
            }
        });
    }

    public boolean isEnabled() {
        return this.getSettings().REFORMAT_BEFORE_PROJECT_COMMIT;
    }

    @Override
    @NotNull
    protected String getProgressMessage() {
        String string = VcsBundle.message((String)"progress.text.reformatting.code", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        return string;
    }

    @Override
    @NotNull
    protected AbstractLayoutCodeProcessor createCodeProcessor(@NotNull List<? extends VirtualFile> files) {
        Intrinsics.checkNotNullParameter(files, (String)"files");
        return (AbstractLayoutCodeProcessor)new ReformatCodeProcessor(this.getProject(), CheckinHandlerUtil.getPsiFiles((Project)this.getProject(), (Collection)files), CodeStyleBundle.message((String)"process.reformat.code.before.commit", (Object[])new Object[0]), null, true);
    }
}

