import { jsx } from 'react/jsx-runtime';
import { css } from '@emotion/css';
import '@grafana/data';
import { useStyles2 } from '@grafana/ui';

const EditorHeader = ({ children }) => {
  const styles = useStyles2(getStyles);
  return /* @__PURE__ */ jsx("div", { className: styles.root, children });
};
const getStyles = (theme) => ({
  root: css({
    display: "flex",
    flexWrap: "wrap",
    alignItems: "center",
    gap: theme.spacing(3),
    minHeight: theme.spacing(4)
  })
});

export { EditorHeader };
//# sourceMappingURL=EditorHeader.js.map
