import { defaults } from 'lodash';
import React, { useRef, useEffect } from 'react';
import { CodeEditor } from '@grafana/ui';

function QueryCodeEditor(props) {
  const { getSuggestions, query } = props;
  const { rawSQL } = defaults(props.query, { rawSQL: "" });
  const onRawSqlChange = (rawSQL2) => {
    const query2 = {
      ...props.query,
      rawSQL: rawSQL2
    };
    props.onChange(query2);
    props.onRunQuery();
  };
  const suggestionsRef = useRef([]);
  useEffect(() => {
    suggestionsRef.current = getSuggestions(query);
  }, [getSuggestions, query]);
  return /* @__PURE__ */ React.createElement(
    CodeEditor,
    {
      language: props.language,
      value: rawSQL,
      onBlur: onRawSqlChange,
      showMiniMap: false,
      showLineNumbers: true,
      getSuggestions: () => suggestionsRef.current,
      height: "240px",
      ...props.editorProps
    }
  );
}

export { QueryCodeEditor };
//# sourceMappingURL=QueryCodeEditor.js.map
