/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ivy.util;

import java.util.ArrayList;
import java.util.List;
import org.apache.ivy.util.MessageLogger;
import org.apache.ivy.util.MessageLoggerHelper;

public abstract class AbstractMessageLogger
implements MessageLogger {
    private List<String> problems = new ArrayList<String>();
    private List<String> warns = new ArrayList<String>();
    private List<String> errors = new ArrayList<String>();
    private boolean showProgress = true;

    @Override
    public void debug(String msg) {
        this.log(msg, 4);
    }

    @Override
    public void verbose(String msg) {
        this.log(msg, 3);
    }

    @Override
    public void deprecated(String msg) {
        this.log("DEPRECATED: " + msg, 1);
    }

    @Override
    public void info(String msg) {
        this.log(msg, 2);
    }

    @Override
    public void rawinfo(String msg) {
        this.rawlog(msg, 2);
    }

    @Override
    public void warn(String msg) {
        this.log("WARN: " + msg, 3);
        this.problems.add("WARN:  " + msg);
        this.getWarns().add(msg);
    }

    @Override
    public void error(String msg) {
        this.log("ERROR: " + msg, 3);
        this.problems.add("\tERROR: " + msg);
        this.getErrors().add(msg);
    }

    @Override
    public List<String> getProblems() {
        return this.problems;
    }

    @Override
    public void sumupProblems() {
        MessageLoggerHelper.sumupProblems(this);
        this.clearProblems();
    }

    @Override
    public void clearProblems() {
        this.problems.clear();
        this.warns.clear();
        this.errors.clear();
    }

    @Override
    public List<String> getErrors() {
        return this.errors;
    }

    @Override
    public List<String> getWarns() {
        return this.warns;
    }

    @Override
    public void progress() {
        if (this.showProgress) {
            this.doProgress();
        }
    }

    @Override
    public void endProgress() {
        this.endProgress("");
    }

    @Override
    public void endProgress(String msg) {
        if (this.showProgress) {
            this.doEndProgress(msg);
        }
    }

    @Override
    public boolean isShowProgress() {
        return this.showProgress;
    }

    @Override
    public void setShowProgress(boolean progress) {
        this.showProgress = progress;
    }

    protected abstract void doProgress();

    protected abstract void doEndProgress(String var1);
}

