---
stage: AI-powered
group: Agent Foundations
info: To determine the technical writer assigned to the Stage/Group associated with this page, see https://handbook.gitlab.com/handbook/product/ux/technical-writing/#assignments
title: SAST Vulnerability Resolution Flow
---

{{< details >}}

- Tier: Ultimate
- Offering: GitLab.com, GitLab Self-Managed, GitLab Dedicated
- Status: Beta

{{< /details >}}

{{< history >}}

- [Introduced](https://gitlab.com/groups/gitlab-org/-/epics/17889) in GitLab 18.9 as a [beta](../../../../policy/development_stages_support.md#beta) feature [with feature flags](../../../../administration/feature_flags/_index.md) named `enable_vulnerability_resolution` and `agentic_sast_vr_ui`. Enabled by default.

{{< /history >}}

Agentic SAST vulnerability resolution automatically analyzes SAST vulnerabilities and generates merge requests with context-aware code fixes. This agentic approach uses multi-shot reasoning to resolve vulnerabilities with minimal human intervention.

When a SAST security scan runs on the main branch, GitLab Duo automatically analyzes high and critical severity vulnerabilities to determine if a fix can be generated with high confidence. The analysis happens in the background and results appear in the vulnerability report once processing is complete.

Results are based on AI analysis and should be reviewed by security professionals. The feature requires GitLab Duo Enterprise with an active subscription.

## Running agentic SAST vulnerability resolution

The flow runs automatically when specific conditions are met. For details on automatic and manual execution, see [Agentic SAST Vulnerability Resolution](../../../application_security/vulnerabilities/agentic_vulnerability_resolution.md).

## Related links

- [Agentic SAST Vulnerability Resolution](../../../application_security/vulnerabilities/agentic_vulnerability_resolution.md).
- [Vulnerability report](../../../application_security/vulnerability_report/_index.md).
- [SAST](../../../application_security/sast/_index.md).
- [GitLab Duo](../../../gitlab_duo/_index.md).
