---
stage: Application Security Testing
group: Dynamic Analysis
info: To determine the technical writer assigned to the Stage/Group associated with this page, see https://handbook.gitlab.com/handbook/product/ux/technical-writing/#assignments
title: '機密のシークレットまたはトークンであるShippoテストAPIトークンの暴露'
---

## 説明 {#description}

レスポンスボディには、ShippoテストAPIトークンのパターンに一致するコンテンツが含まれていることが確認されました。APIトークンは、配送サービスに使用されるShippo APIへのアクセスに使用できます。このトークンにアクセスできる悪意のある攻撃者は、課金および注文情報にアクセスし、配送データを変更することができます。この値を公開すると、攻撃者がこのトークンによって許可されたすべてのリソースにアクセスできるようになる可能性があります。

## 修正 {#remediation}

キーの漏洩に関するセキュリティインシデントの取り扱いに関する一般的なガイダンスについては、GitLabドキュメントの[インターネットへの認証情報の公開](../../../../../security/responding_to_security_incidents.md#credential-exposure-to-public-internet)を参照してください。

APIトークンを失効するには:

- Shippoアカウントにサインインし、<https://apps.goshippo.com/>にアクセスします
- 右上側で、「ギア」アイコンを選択して「設定」ページに移動します
- 左側のメニューで「詳細」までスクロールし、「API」を選択します
- 「トークン」セクションで、「トークンの管理」を選択します
- 識別されたトークンを見つけて、ゴミ箱アイコンを選択します
- プロンプトが表示されたら、「トークンの管理」ダイアログで「はい、トークンを削除」を選択します

詳細については、[ShippoのAPIキーに関するドキュメント](https://portal.goshippo.com/api-config/api)を参照してください。

## 詳細 {#details}

| ID | 集約 | CWE | 型 | リスク |
|:---|:-----------|:----|:-----|:-----|
| 798.171 | いいえ | 798 | パッシブ | 高 |

## リンク {#links}

- [CWE](https://cwe.mitre.org/data/definitions/798.html)
