/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.search;

import docking.ReusableDialogComponentProvider;
import docking.widgets.checkbox.GCheckBox;
import docking.widgets.combobox.GhidraComboBox;
import docking.widgets.label.GLabel;
import ghidra.util.HelpLocation;
import ghidra.util.MessageType;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.MutableComboBoxModel;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.apache.commons.lang3.StringUtils;

public class DecompilerTextFinderDialog
extends ReusableDialogComponentProvider {
    private GhidraComboBox<String> textCombo;
    private JButton searchButton;
    private JCheckBox regexCb;
    private JCheckBox searchSelectionCb;
    private String searchText;
    private boolean isCancelled;

    public DecompilerTextFinderDialog() {
        super("Decompiled Function Search");
        this.addWorkPanel(this.buildMainPanel());
        this.buildButtons();
        this.setHelpLocation(new HelpLocation("DecompilerTextFinderPlugin", "Search_Decompiled_Text"));
    }

    private void buildButtons() {
        this.searchButton = new JButton("Search");
        this.searchButton.addActionListener(ev -> this.doSearch());
        this.addButton(this.searchButton);
        this.setDefaultButton(this.searchButton);
        this.addCancelButton();
    }

    private JPanel buildMainPanel() {
        this.regexCb = new GCheckBox("Regular Expression", false);
        this.regexCb.setName("Regular Expression Search");
        this.regexCb.addItemListener(e -> this.clearStatusText());
        this.searchSelectionCb = new JCheckBox("Search Selection");
        this.searchSelectionCb.setName("Search Selection");
        this.textCombo = new GhidraComboBox();
        this.textCombo.setEditable(true);
        this.textCombo.setColumns(20);
        this.textCombo.addDocumentListener(new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent e) {
                this.handleDocumentUpdate();
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                this.handleDocumentUpdate();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                this.handleDocumentUpdate();
            }

            private void handleDocumentUpdate() {
                String text = DecompilerTextFinderDialog.this.textCombo.getText();
                DecompilerTextFinderDialog.this.searchButton.setEnabled(!StringUtils.isBlank((CharSequence)text));
                DecompilerTextFinderDialog.this.clearStatusText();
            }
        });
        GLabel findLabel = new GLabel("Find: ");
        findLabel.setDisplayedMnemonic(78);
        this.textCombo.associateLabel((JLabel)findLabel);
        JPanel mainPanel = new JPanel(new BorderLayout());
        JPanel textPanel = new JPanel();
        textPanel.setLayout(new BoxLayout(textPanel, 2));
        textPanel.add((Component)findLabel);
        textPanel.add((Component)this.textCombo);
        mainPanel.add((Component)textPanel, "North");
        mainPanel.add((Component)this.buildOptionsPanel(), "South");
        mainPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        return mainPanel;
    }

    private JPanel buildOptionsPanel() {
        JPanel optionsPanel = new JPanel();
        optionsPanel.setLayout(new BoxLayout(optionsPanel, 2));
        optionsPanel.setBorder(BorderFactory.createTitledBorder("Options"));
        optionsPanel.add(this.regexCb);
        optionsPanel.add(Box.createHorizontalGlue());
        optionsPanel.add(this.searchSelectionCb);
        return optionsPanel;
    }

    public void close() {
        this.textCombo.setText("");
        super.close();
    }

    private void doSearch() {
        this.searchText = null;
        this.clearStatusText();
        if (!this.searchButton.isEnabled()) {
            return;
        }
        String text = this.textCombo.getText();
        if (!this.validateRegex(text)) {
            return;
        }
        this.isCancelled = false;
        this.searchText = text;
        this.updateSearchHistory(this.searchText);
        this.close();
    }

    private boolean validateRegex(String text) {
        if (!this.isRegex()) {
            return true;
        }
        try {
            Pattern.compile(text);
            return true;
        }
        catch (PatternSyntaxException e) {
            this.setStatusText("Invalid regex: " + e.getMessage(), MessageType.ERROR);
            return false;
        }
    }

    protected void dialogShown() {
        this.searchButton.setEnabled(false);
        this.clearStatusText();
        this.searchText = null;
        this.isCancelled = true;
    }

    public void setSearchText(String text) {
        this.textCombo.setText(text);
    }

    public String getSearchText() {
        return this.searchText;
    }

    public boolean isSearchSelection() {
        return this.searchSelectionCb.isSelected();
    }

    public void setSearchSelectionEnabled(boolean b) {
        if (!b) {
            this.searchSelectionCb.setEnabled(false);
            this.searchSelectionCb.setSelected(false);
        } else {
            this.searchSelectionCb.setEnabled(true);
        }
    }

    public boolean isRegex() {
        return this.regexCb.isSelected();
    }

    public boolean isCancelled() {
        return this.isCancelled;
    }

    private void updateSearchHistory(String text) {
        MutableComboBoxModel model = (MutableComboBoxModel)this.textCombo.getModel();
        model.insertElementAt(text, 0);
        int size = model.getSize();
        for (int i = 1; i < size; ++i) {
            String element = (String)model.getElementAt(i);
            if (!element.equals(text)) continue;
            model.removeElementAt(i);
            break;
        }
        model.setSelectedItem(text);
    }
}

