/*
 * Decompiled with CFR 0.152.
 */
package ghidra.pyghidra;

import ghidra.pyghidra.PyGhidraScriptProvider;
import ghidra.util.Msg;
import ghidra.util.exception.AssertException;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.invoke.ConstantBootstraps;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;
import java.lang.reflect.Constructor;
import java.util.Map;

public sealed interface PythonFieldExposer
permits PyGhidraScriptProvider.PyGhidraGhidraScript, PyGhidraScriptProvider.PyGhidraHeadlessScript {
    public static Map<String, ExposedField> getProperties(Class<? extends PythonFieldExposer> cls) {
        try {
            return PythonFieldExposer.doGetProperties(cls);
        }
        catch (Throwable t) {
            Msg.error(PythonFieldExposer.class, (Object)("Failed to expose fields for " + cls.getSimpleName()), (Throwable)t);
            return Map.of();
        }
    }

    private static Map<String, ExposedField> doGetProperties(Class<? extends PythonFieldExposer> cls) throws Throwable {
        Class<?>[] types;
        ExposedFields fields = cls.getAnnotation(ExposedFields.class);
        String[] names = fields.names();
        if (names.length != (types = fields.types()).length) {
            throw new AssertException("Improperly applied ExposedFields on " + cls.getSimpleName());
        }
        Constructor<? extends ExposedField> c = fields.exposer().getConstructor(String.class, Class.class);
        Map.Entry[] properties = new Map.Entry[names.length];
        for (int i = 0; i < names.length; ++i) {
            properties[i] = Map.entry(names[i], c.newInstance(names[i], types[i]));
        }
        return Map.ofEntries(properties);
    }

    @Target(value={ElementType.TYPE})
    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface ExposedFields {
        public Class<? extends ExposedField> exposer();

        public String[] names();

        public Class<?>[] types();
    }

    public static abstract class ExposedField {
        private final VarHandle handle;

        protected ExposedField(MethodHandles.Lookup lookup, String name, Class<?> type) {
            this.handle = ConstantBootstraps.fieldVarHandle(lookup, name, VarHandle.class, lookup.lookupClass(), type);
        }

        public final Object fget(Object self) {
            return this.handle.get(self);
        }

        public final void fset(Object self, Object value) {
            this.handle.set(self, value);
        }
    }
}

