/*
 * Decompiled with CFR 0.152.
 */
package ghidra.javaclass.format.attributes;

import ghidra.app.util.bin.BinaryReader;
import ghidra.javaclass.format.attributes.AbstractAttributeInfo;
import ghidra.javaclass.format.attributes.BootstrapMethods;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.StructureDataType;
import ghidra.util.exception.DuplicateNameException;
import java.io.IOException;

public class BootstrapMethodsAttribute
extends AbstractAttributeInfo {
    private short numberOfBootstrapMethods;
    private BootstrapMethods[] bootstrapMethods;

    public BootstrapMethodsAttribute(BinaryReader reader) throws IOException {
        super(reader);
        this.numberOfBootstrapMethods = reader.readNextShort();
        this.bootstrapMethods = new BootstrapMethods[this.getNumberOfBootstrapMethods()];
        for (int i = 0; i < this.getNumberOfBootstrapMethods(); ++i) {
            this.bootstrapMethods[i] = new BootstrapMethods(reader);
        }
    }

    public int getNumberOfBootstrapMethods() {
        return this.numberOfBootstrapMethods & 0xFFFF;
    }

    public BootstrapMethods[] getBootstrapMethods() {
        return this.bootstrapMethods;
    }

    public DataType toDataType() throws DuplicateNameException, IOException {
        StructureDataType structure = this.getBaseStructure("BootstrapMethods_attribute");
        structure.add(WORD, "num_bootstrap_methods", null);
        for (int i = 0; i < this.bootstrapMethods.length; ++i) {
            structure.add(this.bootstrapMethods[i].toDataType(), "bootstrap_methods" + i, null);
        }
        return structure;
    }
}

