/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.database.bookmark;

import ghidra.program.model.address.Address;
import ghidra.program.model.listing.Program;
import ghidra.util.ObjectStorage;
import ghidra.util.Saveable;

public class OldBookmark
implements Saveable {
    private String type;
    private String category;
    private String comment;
    private Address addr;
    private String addrString;

    OldBookmark(OldBookmark info, Address addr) {
        this.type = info.getType();
        this.addr = addr;
        this.category = info.getCategory();
        this.comment = info.getComment();
    }

    public OldBookmark(String type, String category, String comment, Address addr) {
        if (addr == null) {
            throw new IllegalArgumentException("Bookmark address required");
        }
        this.type = type != null ? type : "Note";
        this.category = category;
        this.comment = comment;
        this.addr = addr;
    }

    public OldBookmark() {
        this.type = "";
        this.category = "";
        this.comment = "";
    }

    void setContext(Program program, String type) {
        this.type = type;
        if (this.addrString != null) {
            this.addr = program.parseAddress(this.addrString)[0];
            this.addrString = null;
        }
    }

    public String getType() {
        return this.type;
    }

    public String getCategory() {
        return this.category;
    }

    public void setCategory(String category) {
        this.category = category;
    }

    public String getComment() {
        return this.comment;
    }

    public void setComment(String comment) {
        this.comment = comment;
    }

    public Address getAddress() {
        return this.addr;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OldBookmark bookmark = (OldBookmark)obj;
        boolean addrsEqual = false;
        if (this.addr == null || bookmark.addr == null) {
            if (!this.addrString.equals(bookmark.addrString)) {
                return false;
            }
            addrsEqual = true;
        } else {
            if (this.addr.getClass() != bookmark.addr.getClass()) {
                return false;
            }
            addrsEqual = this.addr.equals(bookmark.addr);
        }
        return this.comment.equals(bookmark.comment) && this.category.equals(bookmark.category) && this.type.equals(bookmark.type) && addrsEqual;
    }

    public void restore(ObjectStorage objStorage) {
        this.category = objStorage.getString();
        this.comment = objStorage.getString();
        this.addrString = objStorage.getString();
    }

    public void save(ObjectStorage objStorage) {
        objStorage.putString(this.category);
        objStorage.putString(this.comment);
        if (this.addr != null) {
            this.addrString = this.addr.toString();
        }
        objStorage.putString(this.addrString);
    }

    public Class<?>[] getObjectStorageFields() {
        return new Class[]{String.class, String.class, String.class};
    }

    public int getSchemaVersion() {
        return 0;
    }

    public boolean isUpgradeable(int oldSchemaVersion) {
        return false;
    }

    public boolean upgrade(ObjectStorage oldObjStorage, int oldSchemaVersion, ObjectStorage currentObjStorage) {
        return false;
    }

    public boolean isPrivate() {
        return false;
    }

    public String toString() {
        return this.category + "/" + this.comment;
    }
}

