/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.pe.cli.tables;

import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.format.pe.NTHeader;
import ghidra.app.util.bin.format.pe.cli.blobs.CliBlob;
import ghidra.app.util.bin.format.pe.cli.blobs.CliSigProperty;
import ghidra.app.util.bin.format.pe.cli.streams.CliAbstractStream;
import ghidra.app.util.bin.format.pe.cli.streams.CliStreamMetadata;
import ghidra.app.util.bin.format.pe.cli.tables.CliAbstractTable;
import ghidra.app.util.bin.format.pe.cli.tables.CliAbstractTableRow;
import ghidra.app.util.bin.format.pe.cli.tables.CliTypeTable;
import ghidra.app.util.bin.format.pe.cli.tables.flags.CliFlags;
import ghidra.app.util.importer.MessageLog;
import ghidra.program.model.address.Address;
import ghidra.program.model.data.CategoryPath;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.StructureDataType;
import ghidra.program.model.listing.Program;
import ghidra.program.model.util.CodeUnitInsertionException;
import ghidra.util.exception.DuplicateNameException;
import ghidra.util.task.TaskMonitor;
import java.io.IOException;

public class CliTableProperty
extends CliAbstractTable {
    public CliTableProperty(BinaryReader reader, CliStreamMetadata stream, CliTypeTable tableId) throws IOException {
        super(reader, stream, tableId);
        for (int i = 0; i < this.numRows; ++i) {
            CliPropertyRow row = new CliPropertyRow(reader.readNextShort(), this.readStringIndex(reader), this.readBlobIndex(reader));
            this.rows.add(row);
            this.strings.add(row.nameIndex);
        }
        reader.setPointerIndex(this.readerOffset);
    }

    public StructureDataType getRowDataType() {
        StructureDataType rowDt = new StructureDataType(new CategoryPath("/PE/CLI/Metadata/Tables"), "Property Row", 0);
        rowDt.add((DataType)CliFlags.CliEnumPropertyAttributes.dataType, "Flags", "Bitmask of type PropertyAttributes");
        rowDt.add(this.metadataStream.getStringIndexDataType(), "Name", null);
        rowDt.add(this.metadataStream.getBlobIndexDataType(), "Type", "Blob index to the signature, not a TypeDef/TypeRef");
        return rowDt;
    }

    @Override
    public void markup(Program program, boolean isBinary, TaskMonitor monitor, MessageLog log, NTHeader ntHeader) throws DuplicateNameException, CodeUnitInsertionException, IOException {
        for (CliAbstractTableRow row : this.rows) {
            CliPropertyRow property = (CliPropertyRow)row;
            CliBlob blob = this.metadataStream.getBlobStream().getBlob(property.sigIndex);
            Address addr = CliAbstractStream.getStreamMarkupAddress(program, isBinary, monitor, log, ntHeader, this.metadataStream.getBlobStream(), property.sigIndex);
            CliSigProperty propSig = new CliSigProperty(blob);
            this.metadataStream.getBlobStream().updateBlob(propSig, addr, program);
        }
    }

    private class CliPropertyRow
    extends CliAbstractTableRow {
        public short flags;
        public int nameIndex;
        public int sigIndex;

        public CliPropertyRow(short flags, int nameIndex, int sigIndex) {
            this.flags = flags;
            this.nameIndex = nameIndex;
            this.sigIndex = sigIndex;
        }

        @Override
        public String getRepresentation() {
            String sigRep = Integer.toHexString(this.sigIndex);
            CliBlob blob = CliTableProperty.this.metadataStream.getBlobStream().getBlob(this.sigIndex);
            try {
                CliSigProperty propertySig = new CliSigProperty(blob);
                sigRep = propertySig.getShortRepresentation(CliTableProperty.this.metadataStream);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return String.format("Property %s Signature %s Flags %s", CliTableProperty.this.metadataStream.getStringsStream().getString(this.nameIndex), sigRep, CliFlags.CliEnumPropertyAttributes.dataType.getName(this.flags & 0xFFFF));
        }
    }
}

