/*
 * Decompiled with CFR 0.152.
 */
package ghidra.file.formats.ios.generic;

import ghidra.util.exception.CryptoException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;

public class iOS_Sha1Crypto {
    private static final String CRYPTO_ALGORITHM = "HmacSHA1";
    private Key macKey;
    private Mac mac;

    public iOS_Sha1Crypto(byte[] key) throws CryptoException {
        this.macKey = new SecretKeySpec(key, CRYPTO_ALGORITHM);
        try {
            this.mac = Mac.getInstance(CRYPTO_ALGORITHM);
            this.mac.init(this.macKey);
        }
        catch (NoSuchAlgorithmException e) {
            throw new CryptoException((Exception)e);
        }
        catch (InvalidKeyException e) {
            throw new CryptoException((Exception)e);
        }
    }

    public void update(byte[] update) {
        this.mac.update(update);
    }

    public byte[] encrypt(byte[] plainText) throws CryptoException {
        throw new CryptoException("encrypt() not implemented");
    }

    public byte[] decrypt(byte[] cipherText) throws CryptoException {
        try {
            return this.mac.doFinal(cipherText);
        }
        catch (IllegalStateException e) {
            throw new CryptoException((Exception)e);
        }
    }

    public byte[] decrypt() throws CryptoException {
        try {
            return this.mac.doFinal();
        }
        catch (IllegalStateException e) {
            throw new CryptoException((Exception)e);
        }
    }
}

