/*
 * Decompiled with CFR 0.152.
 */
package ghidra.file.formats.android.art;

import ghidra.file.formats.android.art.ArtHeader;
import ghidra.program.model.address.Address;
import ghidra.program.model.lang.Processor;
import ghidra.program.model.lang.Register;
import ghidra.program.model.lang.RegisterValue;
import ghidra.program.model.listing.ContextChangeException;
import ghidra.program.model.listing.Group;
import ghidra.program.model.listing.Program;
import ghidra.program.model.listing.ProgramFragment;
import ghidra.program.model.listing.ProgramModule;
import java.math.BigInteger;

public final class ArtUtilities {
    static void createFragment(Program program, String fragmentName, Address start, Address end) throws Exception {
        ProgramModule module = program.getListing().getRootModule(0L);
        ProgramFragment fragment = ArtUtilities.getFragment(module, fragmentName);
        if (fragment == null) {
            fragment = module.createFragment(fragmentName);
        }
        fragment.move(start, end.subtract(1L));
    }

    static ProgramFragment getFragment(ProgramModule module, String fragmentName) {
        Group[] groups;
        for (Group group : groups = module.getChildren()) {
            if (!group.getName().equals(fragmentName)) continue;
            return (ProgramFragment)group;
        }
        return null;
    }

    public static Address adjustForThumbAsNeeded(ArtHeader artHeader, Program program, Address address) {
        long displacement = address.getOffset();
        if (program.getLanguage().getProcessor().equals((Object)Processor.findOrPossiblyCreateProcessor((String)"ARM")) && (displacement & 1L) == 1L) {
            address = address.subtract(1L);
            Register register = program.getLanguage().getRegister("TMode");
            RegisterValue value = new RegisterValue(register, BigInteger.valueOf(1L));
            try {
                program.getProgramContext().setRegisterValue(address, address, value);
            }
            catch (ContextChangeException contextChangeException) {
                // empty catch block
            }
        }
        return address;
    }
}

