/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.pdb.classtype;

import ghidra.app.util.SymbolPath;
import ghidra.app.util.pdb.classtype.VirtualFunctionTableEntry;
import ghidra.program.model.address.Address;
import ghidra.program.model.data.Pointer;

class PlaceholderVirtualFunctionTableEntry
extends VirtualFunctionTableEntry {
    private Address address;

    PlaceholderVirtualFunctionTableEntry(SymbolPath originalMethodPath, SymbolPath overrideMethodPath, Pointer functionPointer) {
        this(originalMethodPath, overrideMethodPath, functionPointer, null);
    }

    PlaceholderVirtualFunctionTableEntry(SymbolPath originalMethodPath, SymbolPath overrideMethodPath, Pointer functionPointer, Address address) {
        super(originalMethodPath, overrideMethodPath, functionPointer);
        this.address = address;
    }

    void setAddress(Address address) {
        this.address = address;
    }

    Address getAddress() {
        return this.address;
    }

    void emit(StringBuilder builder, long vbtPtrOffset) {
        PlaceholderVirtualFunctionTableEntry.emitLine(builder, null, this.overrideMethodPath);
    }

    static void emitHeader(StringBuilder builder) {
        builder.append(String.format("%16s %s\n", "Address", "Path"));
    }

    static void emitLine(StringBuilder builder, Address address, SymbolPath path) {
        builder.append(String.format("%16s %10s\n", address == null ? "<unk_addr>" : address.toString(), path.toString()));
    }
}

