/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.pdb2.pdbreader.type;

import ghidra.app.util.bin.format.pdb2.pdbreader.AbstractPdb;
import ghidra.app.util.bin.format.pdb2.pdbreader.Numeric;
import ghidra.app.util.bin.format.pdb2.pdbreader.PdbByteReader;
import ghidra.app.util.bin.format.pdb2.pdbreader.PdbException;
import ghidra.app.util.bin.format.pdb2.pdbreader.RecordCategory;
import ghidra.app.util.bin.format.pdb2.pdbreader.RecordNumber;
import ghidra.app.util.bin.format.pdb2.pdbreader.StringParseType;
import ghidra.app.util.bin.format.pdb2.pdbreader.type.AbstractMsType;
import java.math.BigInteger;

public class MatrixMsType
extends AbstractMsType {
    public static final int PDB_ID = 5404;
    private RecordNumber elementTypeRecordNumber;
    private long numRows;
    private long numColumns;
    private long majorStride;
    private boolean rowMajor;
    private BigInteger size;
    private String name;

    public MatrixMsType(AbstractPdb pdb, PdbByteReader reader) throws PdbException {
        super(pdb, reader);
        this.elementTypeRecordNumber = RecordNumber.parse(pdb, reader, RecordCategory.TYPE, 32);
        this.numRows = reader.parseUnsignedIntVal();
        this.numColumns = reader.parseUnsignedIntVal();
        this.majorStride = reader.parseUnsignedIntVal();
        int attribute = reader.parseUnsignedByteVal();
        this.rowMajor = (attribute & 1) == 1;
        Numeric numeric = new Numeric(reader);
        if (!numeric.isIntegral()) {
            throw new PdbException("Expecting integral numeric");
        }
        this.size = numeric.getIntegral();
        this.name = reader.parseString(pdb, StringParseType.StringNt);
    }

    @Override
    public int getPdbId() {
        return 5404;
    }

    @Override
    public BigInteger getSize() {
        return this.size;
    }

    public long getNumRows() {
        return this.numRows;
    }

    public long getNumColumns() {
        return this.numColumns;
    }

    public boolean isRowMajor() {
        return this.rowMajor;
    }

    public long getMajorStride() {
        return this.majorStride;
    }

    @Override
    public void emit(StringBuilder builder, AbstractMsType.Bind bind) {
        String elementTypeString = this.pdb.getTypeRecord(this.elementTypeRecordNumber).toString();
        if (this.rowMajor) {
            builder.append(String.format("matrix: %s[row<%s> %d][column<%s> %d]", this.name, elementTypeString, this.numRows, elementTypeString, this.numColumns));
        } else {
            builder.append(String.format("matrix: %s[column<%s> %d][row<%s> %d]", this.name, elementTypeString, this.numColumns, elementTypeString, this.numRows));
        }
    }
}

