/*
 * Decompiled with CFR 0.152.
 */
package docking.widgets;

import docking.DockingUtils;
import docking.actions.KeyBindingUtils;
import generic.theme.GColor;
import ghidra.docking.util.LookAndFeelUtils;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTextPane;
import javax.swing.KeyStroke;
import javax.swing.border.Border;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.text.DefaultCaret;
import org.apache.commons.lang3.StringUtils;
import utility.function.Callback;

public class GHyperlinkComponent
extends JPanel {
    public GHyperlinkComponent() {
        this.setLayout(new BoxLayout(this, 2));
    }

    public void addText(String text) {
        FixedSizeTextPane textPane = new FixedSizeTextPane(text, Callback.dummy());
        textPane.setFocusable(false);
        this.add(textPane);
        Object updated = text;
        int leadingSpaces = text.indexOf(text.trim());
        if (leadingSpaces != 0) {
            updated = StringUtils.repeat((String)"&nbsp;", (int)leadingSpaces) + text.substring(leadingSpaces);
        }
        this.setText(textPane, (String)updated);
        textPane.getAccessibleContext().setAccessibleDescription("");
    }

    public void addLink(String text, Callback linkActivatedCallback) {
        FixedSizeTextPane textPane = new FixedSizeTextPane(text, linkActivatedCallback);
        this.add(textPane);
        this.setText(textPane, "<a href=\"stub\">" + text + "</a>");
        textPane.getAccessibleContext().setAccessibleDescription("Clickable link");
    }

    private void setText(JTextPane textPane, String text) {
        String html = "<html><nobr>" + text;
        textPane.setText(html);
        textPane.getPreferredSize();
        this.getPreferredSize();
    }

    private class FixedSizeTextPane
    extends JTextPane {
        private String rawText;

        FixedSizeTextPane(String rawText, final Callback linkActivatedCallback) {
            this.rawText = rawText;
            this.setContentType("text/html");
            this.setEditable(false);
            this.setCaret(new NonScrollingCaret());
            DockingUtils.setTransparent(this);
            final Border defaultBorder = BorderFactory.createEmptyBorder(1, 1, 1, 1);
            this.setBorder(defaultBorder);
            GColor FOCUS_COLOR = new GColor("color.border.button.focused");
            final Border FOCUSED_BORDER = BorderFactory.createLineBorder((Color)FOCUS_COLOR);
            this.addFocusListener(new FocusListener(){

                @Override
                public void focusLost(FocusEvent e) {
                    FixedSizeTextPane.this.setBorder(defaultBorder);
                }

                @Override
                public void focusGained(FocusEvent e) {
                    FixedSizeTextPane.this.setBorder(FOCUSED_BORDER);
                }
            });
            this.addHyperlinkListener(new HyperlinkListener(){

                @Override
                public void hyperlinkUpdate(HyperlinkEvent e) {
                    HyperlinkEvent.EventType type = e.getEventType();
                    if (type == HyperlinkEvent.EventType.ACTIVATED) {
                        linkActivatedCallback.call();
                    }
                }
            });
            this.addActivationKeyBinding(linkActivatedCallback);
        }

        private void addActivationKeyBinding(final Callback linkActivatedCallback) {
            KeyStroke enterKs = KeyBindingUtils.parseKeyStroke("Enter");
            KeyStroke spaceKs = KeyBindingUtils.parseKeyStroke("Space");
            AbstractAction action = new AbstractAction("Activate Link"){

                @Override
                public void actionPerformed(ActionEvent e) {
                    linkActivatedCallback.call();
                }
            };
            KeyBindingUtils.registerAction((JComponent)this, enterKs, action, 0);
            KeyBindingUtils.registerAction((JComponent)this, spaceKs, action, 0);
        }

        @Override
        public Dimension getMaximumSize() {
            return this.getBestSize();
        }

        @Override
        public Dimension getMinimumSize() {
            return this.getBestSize();
        }

        @Override
        public Dimension getPreferredSize() {
            return this.getBestSize();
        }

        private Dimension getBestSize() {
            int width = this.getBestWidth();
            Dimension d = super.getPreferredSize();
            d.width = Math.min(width, d.width);
            return d;
        }

        private int getBestWidth() {
            Font font = this.getFont();
            FontMetrics fm = this.getFontMetrics(font);
            int stringWidth = fm.stringWidth(this.rawText);
            Dimension preferred = super.getPreferredSize();
            int width = stringWidth;
            if (!LookAndFeelUtils.isUsingFlatUI()) {
                width = Math.max(stringWidth, preferred.width);
            }
            Insets insets = this.getInsets();
            return width += insets.left + insets.right;
        }
    }

    private class NonScrollingCaret
    extends DefaultCaret {
        private NonScrollingCaret() {
            this.setVisible(false);
        }

        @Override
        protected void adjustVisibility(Rectangle nloc) {
        }
    }
}

